/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.archaius.api.Config;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.SSL;
import com.turbospaces.ups.FileServiceInfo;
import com.turbospaces.ups.H2ServiceInfo;
import com.turbospaces.ups.KafkaServiceInfo;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.RawServiceInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.SmartCloudConnector;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.app.BasicApplicationInstanceInfo;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.common.MysqlServiceInfo;
import org.springframework.cloud.service.common.OracleServiceInfo;
import org.springframework.cloud.service.common.PostgresqlServiceInfo;
import org.springframework.cloud.service.common.RedisServiceInfo;
import org.springframework.cloud.util.StandardUriInfoFactory;
import org.springframework.cloud.util.UriInfo;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class ConfigurableCloudConnector
implements SmartCloudConnector {
    public static final String RANDOM = "random";
    public static final String FILE_SUFFIX = "_FILE";
    public static final String ENV_UPS_PREFIX = "UPS_";
    public static final String ENV_CACERT_PREFIX = "CACERT_";
    public static final String ENV_HOSTNAME = "HOSTNAME";
    public static final String ENV_SPACE_NAME = "SPACE_NAME";
    public static final String INDEX = "INDEX";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Sinks.Many<Map<String, ServiceInfo>> services = Sinks.many().replay().latestOrDefault((Object)Maps.newConcurrentMap());
    private ApplicationProperties props;
    private BasicApplicationInstanceInfo instanceInfo;
    private String spaceName;
    private String appId;
    private String instanceId;
    private Disposable subscribe;

    @Override
    public void load(ApplicationProperties appProps, KeyStore keyStore) throws Exception {
        this.props = Objects.requireNonNull(appProps);
        HashMap<String, Object> cloudProps = new HashMap<String, Object>();
        this.configureInstance();
        this.configureAddress(cloudProps);
        this.configureSlot(cloudProps);
        this.configureSiteName(cloudProps);
        this.configureAppName(cloudProps);
        this.subscribe = this.readServices().subscribe((Consumer)new Consumer<Map<String, ServiceInfo>>(){

            @Override
            public void accept(Map<String, ServiceInfo> map) {
                Sinks.EmitResult emitResult = ConfigurableCloudConnector.this.services.tryEmitNext(map);
                if (emitResult.isFailure()) {
                    ConfigurableCloudConnector.this.logger.error("unable to emit services: {}", map.keySet());
                }
            }
        });
        this.instanceInfo = new BasicApplicationInstanceInfo(this.instanceId, this.appId, cloudProps);
        SSL.addCertificates(keyStore, this.readCerts());
        for (ServiceInfo si : this.getServiceInfos()) {
            this.logger.debug("ups('{}')={}", (Object)si.getId(), (Object)si);
        }
    }

    public boolean isInMatchingCloud() {
        boolean isMatching = StringUtils.isNotEmpty((CharSequence)this.spaceName) && StringUtils.isNotEmpty((CharSequence)this.appId);
        this.logger.info("isMatching(spaceName={}, appId={}) = [{}]", new Object[]{this.spaceName, this.appId, isMatching});
        return isMatching;
    }

    public ApplicationInstanceInfo getApplicationInstanceInfo() {
        return this.instanceInfo;
    }

    public List<ServiceInfo> getServiceInfos() {
        return ImmutableList.copyOf(((Map)this.services.asFlux().blockFirst()).values());
    }

    @Override
    public Flux<Map<String, ServiceInfo>> asFlux() {
        return this.services.asFlux();
    }

    public void dispose() {
        if (Objects.nonNull(this.subscribe) && BooleanUtils.isFalse((Boolean)this.subscribe.isDisposed())) {
            this.subscribe.dispose();
        }
    }

    private void configureAddress(Map<String, Object> cloudProps) {
        ApplicationConfig cfg = this.props.cfg();
        String hostname = PlatformUtil.detectIp();
        if (cfg.containsKey("cloud.application.host")) {
            hostname = cfg.getString("cloud.application.host");
        }
        int primaryPort = 8089;
        if (cfg.containsKey("cloud.application.port")) {
            primaryPort = RANDOM.equalsIgnoreCase(cfg.getString("cloud.application.port")) ? PlatformUtil.findAvailableTcpPort() : cfg.getInteger("cloud.application.port");
        }
        int secondaryPort = 8091;
        if (cfg.containsKey("cloud.application.secondary-port")) {
            secondaryPort = RANDOM.equalsIgnoreCase(cfg.getString("cloud.application.secondary-port")) ? PlatformUtil.findAvailableTcpPort() : cfg.getInteger("cloud.application.secondary-port");
        }
        int tertiaryPort = 8093;
        if (cfg.containsKey("cloud.application.tertiary-port")) {
            tertiaryPort = RANDOM.equalsIgnoreCase(cfg.getString("cloud.application.tertiary-port")) ? PlatformUtil.findAvailableTcpPort() : cfg.getInteger("cloud.application.tertiary-port");
        }
        if (StringUtils.isNotEmpty((CharSequence)System.getenv(ENV_HOSTNAME))) {
            hostname = System.getenv(ENV_HOSTNAME);
        }
        this.addCloudProp("cloud.application.host", hostname, cloudProps);
        this.addCloudProp("cloud.application.port", primaryPort, cloudProps);
        this.addCloudProp("cloud.application.secondary-port", secondaryPort, cloudProps);
        this.addCloudProp("cloud.application.tertiary-port", tertiaryPort, cloudProps);
    }

    private void configureSlot(Map<String, Object> cloudProps) {
        ApplicationConfig cfg = this.props.cfg();
        String slot = null;
        if (cfg.containsKey("cloud.application.instance_index") && RANDOM.equalsIgnoreCase(slot = cfg.getString("cloud.application.instance_index"))) {
            slot = RandomStringUtils.randomAlphanumeric((int)this.getClass().getSimpleName().length());
        }
        if (StringUtils.isNotEmpty((CharSequence)System.getenv(INDEX))) {
            slot = System.getenv(INDEX);
        }
        if (StringUtils.isEmpty((CharSequence)slot)) {
            slot = String.valueOf(0);
        }
        this.addCloudProp("cloud.application.instance_index", slot, cloudProps);
    }

    private void configureSiteName(Map<String, Object> cloudProps) {
        ApplicationConfig cfg = this.props.cfg();
        this.spaceName = System.getenv(ENV_SPACE_NAME);
        if (cfg.containsKey("cloud.application.space_name")) {
            this.spaceName = cfg.getString("cloud.application.space_name");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.spaceName)) {
            this.addCloudProp("cloud.application.space_name", this.spaceName, cloudProps);
        }
    }

    private void configureInstance() {
        ApplicationConfig cfg = this.props.cfg();
        if (cfg.containsKey("cloud.application.app-id")) {
            this.appId = cfg.getString("cloud.application.app-id");
        }
        this.instanceId = UUID.randomUUID().toString();
    }

    private void configureAppName(Map<String, Object> cloudProps) {
        ApplicationConfig cfg = this.props.cfg();
        if (cfg.containsKey("cloud.application.name")) {
            String appName = cfg.getString("cloud.application.name");
            this.addCloudProp("cloud.application.name", appName, cloudProps);
        }
    }

    protected Flux<Map<String, ServiceInfo>> readServices() throws Exception {
        String value;
        ImmutableMap.Builder map = ImmutableMap.builder();
        ApplicationConfig cfg = this.props.cfg();
        Config prefixedView = cfg.getPrefixedView("service");
        Iterator it = prefixedView.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            int idx = key.indexOf(".uri");
            if (idx <= 0) continue;
            String serviceId = key.substring(0, idx);
            value = prefixedView.getRawProperty(key).toString();
            this.addServiceInfo(serviceId, value, (ImmutableMap.Builder<String, ServiceInfo>)map);
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().startsWith(ENV_UPS_PREFIX)) continue;
            String key = entry.getKey();
            value = entry.getValue();
            String id = key.substring(ENV_UPS_PREFIX.length()).trim().toLowerCase();
            if (key.endsWith(FILE_SUFFIX)) {
                File f = new File(value);
                byte[] encoded = Files.readAllBytes(f.toPath());
                value = new String(encoded, StandardCharsets.UTF_8);
                id = id.substring(0, id.length() - FILE_SUFFIX.length());
                this.logger.debug("secret={} has been loaded from={} ...", (Object)id, (Object)f);
            }
            this.addServiceInfo(id, value, (ImmutableMap.Builder<String, ServiceInfo>)map);
        }
        return Flux.just((Object)map.build());
    }

    protected Collection<Certificate> readCerts() throws Exception {
        LinkedList cacerts = Lists.newLinkedList();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().startsWith(ENV_CACERT_PREFIX)) continue;
            File pem = new File(entry.getValue());
            byte[] bytes = Files.readAllBytes(pem.toPath());
            String raw = new String(bytes, StandardCharsets.UTF_8);
            try (StringReader reader = new StringReader(raw);
                 PEMParser parser = new PEMParser((Reader)reader);){
                X509CertificateHolder keyInfo = (X509CertificateHolder)parser.readObject();
                try (ByteArrayInputStream io = new ByteArrayInputStream(keyInfo.getEncoded());){
                    CertificateFactory fact = CertificateFactory.getInstance("X.509");
                    X509Certificate cer = (X509Certificate)fact.generateCertificate(io);
                    cacerts.add(cer);
                }
            }
        }
        return cacerts;
    }

    protected void addServiceInfo(String id, String value, ImmutableMap.Builder<String, ServiceInfo> m) {
        switch (id) {
            case "cfg": {
                m.put((Object)id, (Object)new PlainServiceInfo(id, value));
                break;
            }
            case "sentry": 
            case "influx": 
            case "jaeger": {
                m.put((Object)id, (Object)new PlainServiceInfo(id, value));
                break;
            }
            case "kafka": {
                m.put((Object)id, (Object)new KafkaServiceInfo(id, value));
                break;
            }
            case "elastic-search": {
                m.put((Object)id, (Object)new PlainServiceInfo(id, value));
                break;
            }
            case "postgres-owner": 
            case "postgres-app": {
                m.put((Object)id, (Object)new PostgresqlServiceInfo(id, value));
                break;
            }
            case "h2-owner": 
            case "h2-app": {
                m.put((Object)id, (Object)new H2ServiceInfo(id, value));
                break;
            }
            default: {
                Object si = new RawServiceInfo(id, value.getBytes());
                try {
                    StandardUriInfoFactory uriFactory = new StandardUriInfoFactory();
                    UriInfo uriInfo = uriFactory.createUri(value);
                    String scheme = uriInfo.getScheme();
                    if (StringUtils.isNotEmpty((CharSequence)scheme)) {
                        switch (scheme) {
                            case "oracle": {
                                si = new OracleServiceInfo(id, value);
                                break;
                            }
                            case "postgres": {
                                si = new PostgresqlServiceInfo(id, value);
                                break;
                            }
                            case "mysql": {
                                si = new MysqlServiceInfo(id, value);
                                break;
                            }
                            case "redis": {
                                si = new RedisServiceInfo(id, value);
                                break;
                            }
                            case "kafka": {
                                si = new KafkaServiceInfo(id, value);
                                break;
                            }
                            case "file": {
                                si = new FileServiceInfo(id, value);
                                break;
                            }
                            case "http": 
                            case "https": {
                                si = new PlainServiceInfo(id, value);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("unknown schema: " + scheme);
                            }
                        }
                    }
                }
                catch (IllegalArgumentException err) {
                    this.logger.trace(err.getMessage(), (Throwable)err);
                }
                m.put((Object)id, si);
            }
        }
    }

    protected void addCloudProp(String key, Object value, Map<String, Object> map) {
        this.logger.debug("adding {}={}", (Object)key, value);
        map.put(key, Objects.requireNonNull(value));
    }
}

