/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Throwables;
import com.turbospaces.boot.ExecutionPlatform;
import com.turbospaces.boot.Platform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.SSL;
import com.turbospaces.common.SelfSignedCertificateGenerator;
import com.turbospaces.common.ThrowableAction1;
import com.turbospaces.ups.UPSs;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentracing.Tracer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.KeyStore;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.DynamicCloud;
import org.springframework.cloud.SmartCloud;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public interface Bootstrap
extends BeanFactory,
SmartCloud,
UPSs {
    public ConfigurableApplicationContext run(String ... var1);

    public void shutdown() throws Exception;

    public void exit(int var1);

    public DynamicCloud cloud();

    public String spaceName();

    public String appId();

    public String release();

    public boolean isHealthy();

    public boolean isDevMode();

    default public boolean isProdMode() {
        return BooleanUtils.isFalse((Boolean)this.isDevMode());
    }

    public GenericApplicationContext context();

    public Platform globalPlatform();

    public ExecutionPlatform platform(String var1);

    public ApplicationProperties props();

    public ApplicationConfig cfg();

    public KeyStore keyStore();

    public Tracer tracer();

    public void refreshCfg() throws Exception;

    public void squashLogging() throws Exception;

    public int port();

    public int secondaryPort();

    public int tertiaryPort();

    public MetricRegistry metricRegistry();

    public MeterRegistry meterRegistry();

    public HealthCheckRegistry healthCheckRegistry();

    public void registerHealthCheck(String var1, HealthCheck var2);

    @Override
    default public void addUps(ServiceInfo info) {
        this.cloud().addUps(info);
    }

    @Override
    default public boolean removeUps(String id) {
        return this.cloud().removeUps(id);
    }

    @Override
    default public boolean removeUps(ServiceInfo si) {
        return this.cloud().removeUps(si);
    }

    @Override
    default public <T extends ServiceInfo> Flux<ServiceInfo> serviceInfoByName(String ups) {
        return this.cloud().serviceInfoByName(ups);
    }

    @Override
    default public <T extends ServiceInfo> Flux<ServiceInfo> scopedServiceInfoByName(String scope, String name) {
        return this.cloud().scopedServiceInfoByName(scope, name);
    }

    default public Retry retry() {
        return this.props().retry(this.globalPlatform().scheduler());
    }

    default public <V> void retry(V value, ThrowableAction1<V> action) {
        this.retry(value, action, this.globalPlatform().scheduler());
    }

    default public <V> void retry(V value, final ThrowableAction1<V> action, Scheduler scheduler) {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        final AtomicLong seq = new AtomicLong();
        Mono.just(value).doOnError((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }).doOnNext(new Consumer<V>(){

            @Override
            public void accept(V target) {
                try {
                    action.apply(target);
                }
                catch (Exception err) {
                    logger.warn("got failure on iteration: " + seq.getAndIncrement(), (Throwable)err);
                    Throwables.throwIfUnchecked((Throwable)err);
                    throw new UndeclaredThrowableException(err);
                }
            }
        }).retryWhen(this.props().retry(scheduler)).block();
    }

    default public <V> void retry(Flux<V> stream, ThrowableAction1<List<V>> action) {
        this.retry(stream, action, this.globalPlatform().scheduler());
    }

    default public <V> void retry(Flux<V> stream, final ThrowableAction1<List<V>> action, Scheduler scheduler) {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        final AtomicLong seq = new AtomicLong();
        stream.collectList().doOnError((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }).doOnNext(new Consumer<List<V>>(){

            @Override
            public void accept(List<V> target) {
                try {
                    action.apply(target);
                }
                catch (Exception err) {
                    logger.warn("got failure on iteration: " + seq.getAndIncrement(), (Throwable)err);
                    Throwables.throwIfUnchecked((Throwable)err);
                    throw new UndeclaredThrowableException(err);
                }
            }
        }).retryWhen(this.props().retry(scheduler)).block();
    }

    default public <V> V retryCallable(Callable<V> callback) {
        return this.retryCallable(callback, Schedulers.immediate());
    }

    default public <V> V retryCallable(Callable<V> callback, Scheduler scheduler) {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        final MutableObject result = new MutableObject();
        final AtomicLong seq = new AtomicLong();
        Mono.just(callback).doOnError((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }).doOnNext(new Consumer<Callable<V>>(){

            @Override
            public void accept(Callable<V> target) {
                try {
                    Object value = target.call();
                    result.setValue(value);
                }
                catch (Exception err) {
                    logger.warn("got failure on iteration: " + seq.getAndIncrement(), (Throwable)err);
                    Throwables.throwIfUnchecked((Throwable)err);
                    throw new UndeclaredThrowableException(err);
                }
            }
        }).retryWhen(this.props().retry(scheduler)).block();
        return (V)result.getValue();
    }

    default public void createSelfSignedKeyStoreIfAbsent(File file) throws Exception {
        this.createSelfSignedKeyStoreIfAbsent(file, SelfSignedCertificateGenerator.PASSWORD);
    }

    default public void createSelfSignedKeyStoreIfAbsent(File file, String password) throws Exception {
        if (!file.exists()) {
            SelfSignedCertificateGenerator ssc = new SelfSignedCertificateGenerator();
            ssc.setBootstrap(this);
            KeyStore keystore = ssc.call();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                keystore.store(out, password.toCharArray());
                FileUtils.writeByteArrayToFile((File)file, (byte[])out.toByteArray());
            }
        }
    }

    default public Optional<SSLContext> generateSelfSignedCertificate() throws Exception {
        if (((Boolean)this.props().APP_USE_SELF_SIGNED_CERTIFICATE.get()).booleanValue() && this.isDevMode()) {
            File keystoreFile = new File(FileUtils.getUserDirectory().getAbsolutePath() + "/self_signed_keystore");
            this.createSelfSignedKeyStoreIfAbsent(keystoreFile);
            SSL ssl = new SSL();
            ssl.loadKeyStore(keystoreFile, SelfSignedCertificateGenerator.PASSWORD);
            return Optional.of(ssl.build());
        }
        return Optional.empty();
    }
}

