package com.turbospaces.ups;

import java.util.Arrays;
import java.util.Objects;

import org.springframework.cloud.service.ServiceInfo;

public class RawServiceInfo implements ServiceInfo {
    private final String id;
    private final byte[] payload;

    public RawServiceInfo(String id, byte[] payload) {
        this.id = Objects.requireNonNull(id);
        this.payload = Arrays.copyOf(payload, payload.length);
    }
    @Override
    public String getId() {
        return id;
    }
    public byte[] getPayload() {
        return payload;
    }
}
