package com.turbospaces.executor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class ForceQueuePolicy implements RejectedExecutionHandler {
    @Override public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        try {
            executor.getQueue().put(r);
        } catch (InterruptedException e) {
            // should never happen since we never wait
            throw new RejectedExecutionException(e);
        }
    }
}
