package com.turbospaces.cfg;

import java.util.HashMap;

import org.springframework.cloud.app.ApplicationInstanceInfo;

import com.netflix.archaius.config.MapConfig;

public class CloudMapConfig extends MapConfig {
    @SuppressWarnings("serial")
    public CloudMapConfig(ApplicationInstanceInfo info) {
        super(new HashMap<String, String>() {
            {
                for (Entry<String, Object> entry : info.getProperties().entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue().toString();
                    put(k, v);
                }
            }
        });
    }
}
