package com.turbospaces.boot;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor.CallerRunsPolicy;
import java.util.concurrent.TimeUnit;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.cfg.ApplicationProperties;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class FixedSizePlatform extends AbstractPlatform implements Platform {
    private final Scheduler scheduler;
    private final ScheduledThreadPoolExecutor executor;

    public FixedSizePlatform(ApplicationProperties props, MeterRegistry meter) {
        super(props);

        int size = props.APP_PLATFORM_POOL_SIZE.get();

        ThreadFactoryBuilder factory = new ThreadFactoryBuilder();
        factory.setDaemon(false);
        factory.setNameFormat("platform-worker-%d");

        executor = new ScheduledThreadPoolExecutor(size, factory.build(), new CallerRunsPolicy());
        executor.prestartAllCoreThreads();

        scheduler = Schedulers.fromExecutorService( executor, "reactor" );

        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics( executor, "platform", Collections.emptyList() );
        metrics.bindTo( meter );
    }
    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return executor.schedule( command, delay, unit );
    }
    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return executor.schedule( callable, delay, unit );
    }
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return executor.scheduleAtFixedRate( command, initialDelay, period, unit );
    }
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return executor.scheduleWithFixedDelay( command, initialDelay, delay, unit );
    }
    @Override
    public Scheduler scheduler() {
        return scheduler;
    }
    @Override
    public ExecutorService executor() {
        return executor;
    }
}
