package com.turbospaces.boot;

import org.apache.http.client.utils.URIBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import com.codahale.metrics.health.HealthCheck;
import com.turbospaces.boot.MockConfig.Foo;
import com.turbospaces.healthchecks.HttpHealthCheck;
import com.turbospaces.healthchecks.SocketHealthCheck;
import com.turbospaces.ups.PlainServiceInfo;

import io.jaegertracing.client.Version;

@ExtendWith(SpringExtension.class)
@BootstrapWith(MockSpringBootTestContextBootstrapper.class)
@ContextConfiguration(classes = { MockConfig.class })
public class BootstrapTest extends AbstractBootstrapAware {
    @Autowired
    private Foo foo;

    @Test
    public void works() throws Throwable {
        URIBuilder uri = new URIBuilder().setScheme("http").setHost("localhost").setPath("/v1/status").setPort(bootstrap.port());

        HealthCheck check1 = new HttpHealthCheck(bootstrap.props(), uri.build());
        Assertions.assertTrue(check1.execute().isHealthy());

        SocketHealthCheck check2 = new SocketHealthCheck(bootstrap.props(), new PlainServiceInfo("my-service-" + Version.get(), uri.toString()));
        Assertions.assertTrue(check2.execute().isHealthy());

        logger.debug(foo.toString());
    }
}
