package com.turbospaces.ups;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

import org.springframework.cloud.service.ServiceInfo;

import com.turbospaces.boot.Bootstrap;

import reactor.core.publisher.Flux;

public interface UPSs {
    String CFG = "cfg";
    String SENTRY = "sentry";
    String ELASTIC_SEARCH = "elastic-search";
    String INFLUX = "influx";
    String JAEGER = "jaeger";

    //
    // ~ multiple peers potentially
    //
    String KAFKA = "kafka";

    //
    // ~ DDL
    //
    String POSTGRES_OWNER = "postgres-owner";
    String H2_OWNER = "h2-owner";

    //
    // ~ DML
    //
    String POSTGRES_APP = "postgres-app";
    String H2_APP = "h2-app";

    //
    // ~ quartz
    //
    String QUARTZ_APP = "quartz-app";

    <T extends ServiceInfo> Flux<ServiceInfo> serviceInfoByName(String ups);
    <T extends ServiceInfo> Flux<ServiceInfo> scopedServiceInfoByName(String scope, String name);

    @SuppressWarnings("unchecked")
    static <T extends ServiceInfo> Optional<T> findServiceInfoByName(Bootstrap boot, String name) {
        List<ServiceInfo> serviceInfos = boot.cloud().getServiceInfos();
        return (Optional<T>) serviceInfos.stream().filter(new Predicate<ServiceInfo>() {
            @Override
            public boolean test(ServiceInfo input) {
                return input.getId().equals(name);
            }
        }).findAny();
    }
    @SuppressWarnings("unchecked")
    static <T extends ServiceInfo> T findRequiredServiceInfoByName(Bootstrap bootstrap, String name) {
        return (T) findServiceInfoByName(bootstrap, name).get();
    }
    static <T extends ServiceInfo> Optional<T> findScopedServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = findServiceInfoByName(bootstrap, String.format("%s-%s", scope, name));
        if (opt.isPresent()) {
            return opt;
        }
        opt = findServiceInfoByName(bootstrap, name);
        return opt;
    }
    @SuppressWarnings("unchecked")
    static <T extends ServiceInfo> T findScopedRequiredServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<ServiceInfo> opt = findServiceInfoByName(bootstrap, String.format("%s-%s", scope, name));
        if (opt.isPresent()) {
            return (T) opt.get();
        }
        opt = findServiceInfoByName(bootstrap, name);
        return (T) opt.get();
    }
}
