/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.ConfigurablePlatform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.ThrowableAction;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurablePlatformTest {
    @Test
    public void works() throws Exception {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        ApplicationConfig cfg = ApplicationConfig.create((Duration)Duration.ofDays(1L));
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.getKey(), (Object)Duration.ofSeconds(1L));
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        ConfigurablePlatform platform = new ConfigurablePlatform("test", new ApplicationProperties(cfg), (MeterRegistry)registry);
        final CountDownLatch semaphore = new CountDownLatch(1);
        final CountDownLatch l = new CountDownLatch(1);
        final CountDownLatch interrupted = new CountDownLatch(1);
        platform.work(new ThrowableAction(){

            public void apply() throws Exception {
                System.out.println("work");
                semaphore.await();
                l.countDown();
            }
        });
        platform.execute(new Runnable(){

            @Override
            public void run() {
                System.out.println("execute");
                semaphore.countDown();
            }
        });
        l.await();
        final CountDownLatch started = new CountDownLatch(1);
        platform.work(new ThrowableAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        logger.debug("about to hang forever ...");
                        Thread.sleep(1000L);
                        logger.debug("count down to mark started ...");
                        started.countDown();
                        this.wait();
                    }
                    catch (InterruptedException err) {
                        interrupted.countDown();
                    }
                }
            }
        });
        started.await();
        platform.dispose();
        interrupted.await();
    }
}

