/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.turbospaces.boot.AbstractBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.cfg.CloudMapConfig;
import com.turbospaces.ups.PlainServiceInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.CloudException;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.DynamicCloud;
import org.springframework.cloud.SmartCloudConnector;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class ConfigurableCloudFactory
extends CloudFactory {
    private static final String[] PROPERTY_FILE_EXTENSIONS = new String[]{"properties", "props"};
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ThreadPoolTaskScheduler timer = new ThreadPoolTaskScheduler();
    private final Object mutex = new Object();
    private final AbstractBootstrap<?> bootstrap;
    private final DynamicCloud cloud;
    private final MutableObject<URL> logFile;

    public ConfigurableCloudFactory(SmartCloudConnector connector, AbstractBootstrap<?> bootstrap, MutableObject<URL> logFile) throws Exception {
        this.registerCloudConnector(connector);
        this.bootstrap = Objects.requireNonNull(bootstrap);
        this.logFile = Objects.requireNonNull(logFile);
        if (!connector.isInMatchingCloud()) {
            throw new CloudException("No suitable cloud connector found");
        }
        this.cloud = new DynamicCloud(connector, this.getServiceCreators());
        this.timer.setDaemon(true);
        this.timer.afterPropertiesSet();
        for (ServiceInfo si : connector.getServiceInfos()) {
            if (!si.getId().equals("cfg")) continue;
            this.refresh();
            if (!((Boolean)((ApplicationProperties)bootstrap.props()).APP_CFG_DYNAMIC_POLLING_ENABLED.get()).booleanValue()) continue;
            this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConfigurableCloudFactory.this.refresh();
                    }
                    catch (Throwable err) {
                        ConfigurableCloudFactory.this.logger.error(err.getMessage(), err);
                    }
                }
            }, (Duration)((ApplicationProperties)bootstrap.props()).APP_TIMER_INTERVAL.get());
        }
        CloudMapConfig cfc = new CloudMapConfig(connector.getApplicationInstanceInfo());
        DefaultSettableConfig config = (DefaultSettableConfig)bootstrap.cfg().getConfig("core.CLOUD_CFG");
        config.setProperties((Config)cfc);
    }

    public DynamicCloud getCloud() {
        return this.cloud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            for (ServiceInfo si : this.cloud.getServiceInfos()) {
                if (!si.getId().equals("cfg")) continue;
                PlainServiceInfo info = (PlainServiceInfo)si;
                File toFile = Files.createTempDirectory("cfg", new FileAttribute[0]).toFile();
                InitCommand initCmd = new InitCommand().setBare(false).setDirectory(toFile);
                this.logger.debug("cloning git repo from={}", (Object)info);
                try {
                    Git git = initCmd.call();
                    try {
                        String filename;
                        File fapp;
                        File dapp;
                        this.applyConfig(git, info);
                        PullCommand pullCommand = git.pull().setRemote("origin").setTagOpt(TagOpt.NO_TAGS);
                        pullCommand.setRemoteBranchName("master");
                        if (StringUtils.isNotEmpty((CharSequence)info.getUserName()) && StringUtils.isNotEmpty((CharSequence)info.getPassword())) {
                            pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(info.getUserName(), info.getPassword()));
                        }
                        pullCommand.call();
                        Map cloudProps = this.cloud.getApplicationInstanceInfo().getProperties();
                        String spaceName = cloudProps.get("cloud.application.space_name").toString();
                        String appId = this.cloud.getApplicationInstanceInfo().getAppId();
                        this.logger.debug("looking for property files in {}:{}", (Object)spaceName, (Object)appId);
                        File dspace = new File(toFile, spaceName);
                        if (!dspace.exists() || !dspace.isDirectory()) continue;
                        Collection dprops = FileUtils.listFiles((File)dspace, (String[])PROPERTY_FILE_EXTENSIONS, (boolean)false);
                        if (Objects.nonNull(dprops)) {
                            for (File f : dprops) {
                                if (!f.isFile()) continue;
                                this.load(f);
                            }
                        }
                        if (!(dapp = new File(dspace, appId)).exists() || !dapp.isDirectory()) continue;
                        Collection aprops = FileUtils.listFiles((File)dapp, (String[])PROPERTY_FILE_EXTENSIONS, (boolean)false);
                        if (Objects.nonNull(aprops)) {
                            for (File f : aprops) {
                                if (!f.isFile()) continue;
                                this.load(f);
                            }
                        }
                        if (!(fapp = new File(dapp, filename = "logging.xml")).exists() || !fapp.isFile()) continue;
                        this.logFile.setValue((Object)fapp.toURI().toURL());
                    }
                    finally {
                        if (git == null) continue;
                        git.close();
                    }
                }
                finally {
                    if (!toFile.exists()) continue;
                    toFile.delete();
                }
            }
        }
    }

    private void load(File f) throws Exception {
        ApplicationConfig cfg = this.bootstrap.cfg();
        final Properties props = new Properties();
        try (FileInputStream io = new FileInputStream(f);){
            this.logger.debug("loading space shared propertries from: {}", (Object)f.getAbsolutePath());
            props.load(io);
        }
        String name = Paths.get(f.getParentFile().getName(), f.getName()).toString();
        DefaultCompositeConfig gitComposeConfig = (DefaultCompositeConfig)cfg.getConfig("core.GIT_CFG");
        DefaultSettableConfig fcfg = (DefaultSettableConfig)gitComposeConfig.getConfig(name);
        if (Objects.isNull(fcfg)) {
            fcfg = new DefaultSettableConfig();
            gitComposeConfig.addConfig(name, (Config)fcfg);
        }
        final HashSet toRemove = new HashSet();
        fcfg.forEachProperty((BiConsumer)new BiConsumer<String, Object>(){

            @Override
            public void accept(String k, Object v) {
                if (!props.containsKey(k)) {
                    toRemove.add(k);
                }
            }
        });
        if (!toRemove.isEmpty()) {
            this.logger.debug("found orphaned properties: {}", toRemove);
            for (String prop : toRemove) {
                fcfg.clearProperty(prop);
            }
        }
        this.logger.debug("setting git cfg props={}", (Object)props);
        fcfg.setProperties(props);
    }

    private void applyConfig(Git git, PlainServiceInfo info) throws URISyntaxException, IOException {
        this.logger.debug("patching git config ...");
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("gc", null, "autoDetach", false);
        if (this.bootstrap.isDevMode()) {
            config.setBoolean("http", null, "sslVerify", false);
        }
        URIish urish = new URIish(StringUtils.removeEnd((String)info.getUri(), (String)"/"));
        RemoteConfig remoteConfig = new RemoteConfig((org.eclipse.jgit.lib.Config)config, "origin");
        remoteConfig.addURI(urish);
        RefSpec refSpec = new RefSpec();
        refSpec = refSpec.setForceUpdate(true);
        refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + remoteConfig.getName() + "/*");
        remoteConfig.addFetchRefSpec(refSpec);
        remoteConfig.update((org.eclipse.jgit.lib.Config)config);
        config.save();
    }
}

