package com.turbospaces.ups;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

import org.springframework.cloud.service.ServiceInfo;

import com.turbospaces.boot.Bootstrap;

import reactor.core.publisher.Flux;

public interface UPSs {
    //
    // ~ GIT
    //
    String CFG = "cfg";

    //
    // ~ multiple peers potentially
    //
    String KAFKA = "kafka";
    String ELASTIC_SEARCH = "elastic-search";

    String SENTRY = "sentry";
    String INFLUX = "influx";
    String JAEGER = "jaeger";
    String REDIS = "redis";

    // ~ load testing
    String LOCUST = "locust";

    //
    // ~ DDL
    //
    String POSTGRES_OWNER = "postgres-owner";
    String H2_OWNER = "h2-owner";

    //
    // ~ DML
    //
    String POSTGRES_APP = "postgres-app";
    String H2_APP = "h2-app";

    //
    // ~ quartz
    //
    String QUARTZ_APP = "quartz-app";

    //
    // ~ quartz
    //
    String DEBEZIUM_APP = "debezium-app";

    <T extends ServiceInfo> Flux<ServiceInfo> serviceInfoByName(String ups);
    <T extends ServiceInfo> Flux<ServiceInfo> scopedServiceInfoByName(String scope, String name);

    @SuppressWarnings("unchecked")
    static <T extends ServiceInfo> Optional<T> findServiceInfoByName(Bootstrap boot, String name) {
        List<ServiceInfo> serviceInfos = boot.cloud().getServiceInfos();
        return (Optional<T>) serviceInfos.stream().filter(new Predicate<ServiceInfo>() {
            @Override
            public boolean test(ServiceInfo input) {
                return input.getId().equals(name);
            }
        }).findAny();
    }
    static <T extends ServiceInfo> Optional<T> findScopedServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = findServiceInfoByName(bootstrap, scope + "-" + name);
        if (opt.isPresent()) {
            return opt;
        }
        opt = findServiceInfoByName(bootstrap, name);
        return opt;
    }
    @SuppressWarnings("unchecked")
    static <T extends ServiceInfo> T findScopedRequiredServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<ServiceInfo> opt = findServiceInfoByName(bootstrap, scope + "-" + name);
        if (opt.isPresent()) {
            return (T) opt.get();
        }
        opt = findServiceInfoByName(bootstrap, name);
        return (T) opt.get();
    }
    @SuppressWarnings("unchecked")
    static <T extends ServiceInfo> T findRequiredServiceInfoByName(Bootstrap bootstrap, String name) {
        return (T) findServiceInfoByName(bootstrap, name).get();
    }
}
