/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudConnector;
import org.springframework.cloud.SmartCloud;
import org.springframework.cloud.SmartCloudConnector;
import org.springframework.cloud.service.ServiceConnectorCreator;
import org.springframework.cloud.service.ServiceInfo;

public class DynamicCloud
extends Cloud
implements SmartCloud {
    private final Map<String, ServiceInfo> upss = Maps.newConcurrentMap();

    public DynamicCloud(SmartCloudConnector cloudConnector, List<ServiceConnectorCreator<?, ? extends ServiceInfo>> serviceConnectorCreators) {
        super((CloudConnector)cloudConnector, serviceConnectorCreators);
    }

    public List<ServiceInfo> getServiceInfos() {
        if (this.upss.isEmpty()) {
            return super.getServiceInfos();
        }
        ImmutableList.Builder l = ImmutableList.builder();
        l.addAll((Iterable)super.getServiceInfos());
        l.addAll(this.upss.values());
        return l.build();
    }

    public ServiceInfo getServiceInfo(String serviceId) {
        ServiceInfo si = this.upss.get(serviceId);
        return Objects.nonNull(si) ? si : super.getServiceInfo(serviceId);
    }

    public <T extends ServiceInfo> List<T> getServiceInfosByType(Class<T> serviceInfoType) {
        ImmutableList.Builder l = ImmutableList.builder();
        l.addAll((Iterable)super.getServiceInfosByType(serviceInfoType));
        for (ServiceInfo serviceInfo : this.upss.values()) {
            if (!serviceInfoType.isAssignableFrom(serviceInfo.getClass())) continue;
            l.add((Object)serviceInfo);
        }
        return l.build();
    }

    @Override
    public void addUps(ServiceInfo info) {
        List l = super.getServiceInfos();
        for (ServiceInfo si : l) {
            if (!si.getId().equals(info.getId())) continue;
            throw new IllegalArgumentException(String.format("ups: %s already exists and defined in cloud connector", info.getId()));
        }
        this.upss.put(info.getId(), info);
    }

    @Override
    public boolean removeUps(String id) {
        return Objects.nonNull(this.upss.remove(id));
    }

    @Override
    public boolean removeUps(ServiceInfo si) {
        return Objects.nonNull(this.upss.remove(si.getId()));
    }
}

