/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.netflix.archaius.api.Property;
import com.turbospaces.cfg.ApplicationConfig;
import java.math.BigDecimal;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import reactor.core.scheduler.Scheduler;
import reactor.util.retry.Retry;

public interface TypedPropertyFactory {
    public ApplicationConfig cfg();

    public boolean warnInconsistency(String ... var1) throws Exception;

    public Retry retry(Scheduler var1);

    public Property<List<Integer>> listOfInts(String var1);

    public Property<List<Long>> listOfLongs(String var1);

    public Property<List<String>> listOfStrings(String var1);

    public Property<List<Double>> listOfDoubles(String var1);

    public Property<List<BigDecimal>> listOfBigDecimals(String var1);

    public Property<List<LocalDate>> listOfLocalDates(String var1);

    public Property<List<Pattern>> listOfPatterns(String var1);

    public Property<Map<String, Integer>> mapOfStringInts(String var1);

    public Property<Map<String, Long>> mapOfStringLongs(String var1);

    public Property<Map<String, String>> mapOfStringStrings(String var1);

    public Property<Map<String, Double>> mapOfStringDoubles(String var1);

    public Property<Map<String, BigDecimal>> mapOfStringBigDecimals(String var1);

    public Property<Set<Integer>> setOfInts(String var1);

    public Property<Set<Long>> setOfLongs(String var1);

    public Property<Set<String>> setOfStrings(String var1);

    public Property<Set<Double>> setOfDoubles(String var1);

    public Property<Set<BigDecimal>> setOfBigDecimals(String var1);

    public Property<Set<LocalDate>> setOfLocalDates(String var1);

    public Property<Set<Pattern>> setOfPatterns(String var1);

    public Property<Duration> rangeValue(String var1, Duration var2, Range<Duration> var3);

    public void analyze(URL var1) throws Exception;

    public String externalIp();

    default public void putValueIfPresent(String key, ImmutableMap.Builder<String, String> map) {
        if (this.cfg().containsKey(key)) {
            String raw = Objects.requireNonNull(this.cfg().getString(key));
            map.put((Object)key, (Object)raw);
        }
    }

    default public void putValue(String key, ImmutableMap.Builder<String, String> map, String defaultValue) {
        if (this.cfg().containsKey(key)) {
            String raw = Objects.requireNonNull(this.cfg().getString(key));
            map.put((Object)key, (Object)raw);
        } else {
            map.put((Object)key, (Object)Objects.requireNonNull(defaultValue));
        }
    }
}

