/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import com.google.common.io.ByteSource;
import com.google.common.net.HostAndPort;
import com.turbospaces.ups.H2ServiceInfo;
import com.turbospaces.ups.KafkaServiceInfo;
import com.turbospaces.ups.RawServiceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.common.RedisServiceInfo;

public interface SmartCloud {
    public void addUps(ServiceInfo var1);

    public boolean removeUps(String var1);

    public boolean removeUps(ServiceInfo var1);

    default public void withKafka(int port) {
        this.withKafka(HostAndPort.fromParts((String)"localhost", (int)port));
    }

    default public void withKafka(HostAndPort addr) {
        KafkaServiceInfo info = new KafkaServiceInfo(addr);
        this.addUps((ServiceInfo)info);
    }

    default public void withRedis(int port) {
        this.withRedis(HostAndPort.fromParts((String)"localhost", (int)port));
    }

    default public void withRedis(HostAndPort addr) {
        RedisServiceInfo info = new RedisServiceInfo("redis", addr.getHost(), addr.getPort(), "na");
        this.addUps((ServiceInfo)info);
    }

    default public void withRawService(String id, URL url) throws IOException {
        try (final InputStream io = url.openStream();){
            RawServiceInfo serviceInfo = new RawServiceInfo(id, new ByteSource(){

                public InputStream openStream() throws IOException {
                    return io;
                }
            }.read());
            this.addUps(serviceInfo);
        }
    }

    default public void withH2(boolean durable, String namespace) {
        String url = "mem:" + namespace;
        if (durable) {
            url = url + ";DB_CLOSE_DELAY=-1";
        }
        this.addUps(new H2ServiceInfo("h2-owner", url));
        this.addUps(new H2ServiceInfo("h2-app", url));
    }
}

