/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplyFuture<T>
extends CompletableFuture<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestReplyFuture.class);
    private final Object key;
    private ScheduledFuture<?> timeoutTask;

    public RequestReplyFuture(Object key, ScheduledFuture<?> timeoutTask) {
        this.key = key;
        this.timeoutTask = timeoutTask;
    }

    @Override
    public boolean complete(T value) {
        boolean toReturn = super.complete(value);
        if (this.timeoutTask != null && !this.timeoutTask.isCancelled()) {
            LOGGER.trace("about to cancel timeout task for key: {}", this.key);
            this.timeoutTask.cancel(false);
            this.timeoutTask = null;
        }
        return toReturn;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean toReturn = super.completeExceptionally(ex);
        this.timeoutTask = null;
        return toReturn;
    }
}

