/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLocker
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FileChannel channel;
    private FileLock flock = null;

    public FileLocker(File file) throws FileNotFoundException, IOException {
        this.channel = new RandomAccessFile(file, "rw").getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws IOException {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            this.flock = this.channel.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() throws IOException {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            try {
                this.flock = this.channel.tryLock();
                return this.flock != null;
            }
            catch (OverlappingFileLockException err) {
                this.logger.debug(err.getMessage(), (Throwable)err);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IOException {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            if (this.flock != null) {
                this.flock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            this.unlock();
            this.channel.close();
        }
    }
}

