/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.GitRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitRepository
implements GitRepository {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Repository repository;
    private final ApplicationConfig cfg;

    public JGitRepository(Repository repository, ApplicationConfig cfg) {
        this.repository = Objects.requireNonNull(repository);
        this.cfg = Objects.requireNonNull(cfg);
    }

    @Override
    public void readme() throws Exception {
        try (Git git = new Git(this.repository);){
            File touch = new File(this.repository.getDirectory().getParent(), "readme");
            FileUtils.touch((File)touch);
            git.add().addFilepattern(touch.getName()).call();
            git.commit().setMessage(UUID.randomUUID().toString() + ":" + touch.getName()).call();
        }
    }

    @Override
    public void spaceProps(String name, Properties props) throws Exception {
        try (Git git = new Git(this.repository);){
            String spaceName = this.cfg.getString("cloud.application.space_name");
            File space = new File(this.repository.getDirectory().getParent(), spaceName);
            File touch = new File(space, name);
            FileUtils.touch((File)touch);
            try (FileOutputStream out = new FileOutputStream(touch);){
                props.store(out, spaceName);
                this.logger.info("stored space props: {} into: {}", (Object)props, (Object)touch);
            }
            git.add().addFilepattern(".").call();
            git.commit().setMessage(UUID.randomUUID().toString() + ":" + touch.getName()).call();
        }
    }

    @Override
    public void appProps(String name, Properties props) throws Exception {
        try (Git git = new Git(this.repository);){
            String spaceName = this.cfg.getString("cloud.application.space_name");
            String appId = this.cfg.getString("cloud.application.app-id");
            File space = new File(this.repository.getDirectory().getParent(), spaceName);
            File app = new File(space, appId);
            File touch = new File(app, name);
            FileUtils.touch((File)touch);
            try (FileOutputStream out = new FileOutputStream(touch);){
                props.store(out, spaceName);
                this.logger.info("stored app props: {} into: {}", (Object)props, (Object)touch);
            }
            git.add().addFilepattern(".").call();
            git.commit().setMessage(UUID.randomUUID().toString() + ":" + touch.getName()).call();
        }
    }
}

