/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class InjectBootstrapContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Bootstrap bootstrap;

    public InjectBootstrapContextInitializer(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }

    public void initialize(ConfigurableApplicationContext ctx) {
        ConfigurableListableBeanFactory factory = ctx.getBeanFactory();
        factory.addBeanPostProcessor((BeanPostProcessor)new DestructionAwareBeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof BootstrapAware) {
                    try {
                        ((BootstrapAware)bean).setBootstrap(InjectBootstrapContextInitializer.this.bootstrap);
                    }
                    catch (Exception err) {
                        throw new BeanCreationException(err.getMessage(), (Throwable)err);
                    }
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
            }
        });
    }
}

