/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.net.HostAndPort;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.UPSs;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.jgit.lib.Repository;
import org.springframework.cloud.SmartCloud;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.util.ResourceUtils;

public class MockCloud
implements SmartCloud {
    private final Properties cloudPropsOverride = new Properties();
    private final ApplicationConfig cfg;
    private final Set<ServiceInfo> services = new LinkedHashSet<ServiceInfo>();
    private final String spaceName;
    private final String appId;
    private final String appName;

    private MockCloud(String appId, String appName) throws ConfigException {
        this.appId = Objects.requireNonNull(appId);
        this.appName = Objects.requireNonNull(appName);
        this.spaceName = RandomStringUtils.randomAlphabetic((int)4);
        this.cfg = ApplicationConfig.create(Duration.ofSeconds(30L));
    }

    @Override
    public void addUps(ServiceInfo info) {
        this.services.add(info);
    }

    @Override
    public boolean removeUps(String id) {
        Iterator<ServiceInfo> it = this.services.iterator();
        while (it.hasNext()) {
            ServiceInfo si = it.next();
            if (!si.getId().equals(id)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUps(ServiceInfo si) {
        return this.services.remove(si);
    }

    public MockCloud witCfg(int port, Repository repo) {
        return this.withCfg(HostAndPort.fromParts((String)"localhost", (int)port), repo);
    }

    public MockCloud withCfg(HostAndPort addr, Repository repo) {
        PlainServiceInfo info = new PlainServiceInfo("cfg", "http", addr, null, null, repo.getIdentifier());
        this.addUserProvidedService((ServiceInfo)info);
        return this;
    }

    public MockCloud appPort(int port) {
        this.cloudPropsOverride.put("cloud.application.port", (Object)port);
        return this;
    }

    public MockCloud addUserProvidedService(ServiceInfo info) {
        this.services.add(info);
        return this;
    }

    public ApplicationConfig build() throws Exception {
        String slot = "0";
        int port = PlatformUtil.findAvailableTcpPort();
        String hostname = PlatformUtil.detectIp();
        Properties props = new Properties();
        props.put("cloud.application.app-id", this.appId);
        props.put("cloud.application.space_name", this.spaceName);
        props.put("cloud.application.host", hostname);
        props.put("cloud.application.port", (Object)port);
        props.put("cloud.application.instance_index", slot);
        props.put("cloud.application.name", this.appName);
        props.putAll((Map<?, ?>)this.cloudPropsOverride);
        this.cfg.setLocalProperties(UPSs.addUserProvideServices(props, this.services));
        return this.cfg;
    }

    public static MockCloud fromClasspathAppProps() throws Exception {
        URL resource = ResourceUtils.getURL((String)"classpath:application.properties");
        return MockCloud.fromClasspathAppProps(resource);
    }

    public static MockCloud fromClasspathAppProps(URL url) throws Exception {
        try (InputStream io = url.openStream();){
            Properties props = new Properties();
            props.load(io);
            String appId = props.getProperty("cloud.application.app-id");
            String appName = props.getProperty("cloud.application.name", MockCloud.randomAppName());
            MockCloud mockCloud = new MockCloud(appId, appName);
            return mockCloud;
        }
    }

    public static MockCloud newMock() throws ConfigException {
        int length = MockCloud.class.getSimpleName().length();
        String randomAppId = "app-" + RandomStringUtils.randomAlphanumeric((int)length);
        return new MockCloud(randomAppId, MockCloud.randomAppName());
    }

    private static String randomAppName() {
        int length = MockCloud.class.getSimpleName().length();
        LocalDate now = LocalDate.now(ZoneOffset.UTC);
        String randomGroup = "group-" + RandomStringUtils.randomAlphanumeric((int)length);
        String randomAppId = "app-" + RandomStringUtils.randomAlphanumeric((int)length);
        String randomVersion = now.getYear() + "" + now.getMonthValue() + "" + now.getDayOfMonth();
        String randomAppName = String.format("%s:%s:%s", randomGroup, randomAppId, randomVersion);
        return randomAppName;
    }
}

