/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.MockConfig;
import com.turbospaces.boot.MockSpringBootTestContextBootstrapper;
import com.turbospaces.healthchecks.HttpHealthCheck;
import com.turbospaces.healthchecks.SocketHealthCheck;
import com.turbospaces.ups.PlainServiceInfo;
import io.jaegertracing.client.Version;
import org.apache.http.client.utils.URIBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@BootstrapWith(value=MockSpringBootTestContextBootstrapper.class)
@ContextConfiguration(classes={MockConfig.class})
public class BootstrapTest
extends AbstractBootstrapAware {
    @Autowired
    private MockConfig.Foo foo;

    @Test
    public void works() throws Throwable {
        URIBuilder uri = new URIBuilder().setScheme("http").setHost("localhost").setPath("/v1/status").setPort(this.bootstrap.port());
        HttpHealthCheck check1 = new HttpHealthCheck(this.bootstrap.props(), uri.build());
        Assertions.assertTrue((boolean)check1.execute().isHealthy());
        SocketHealthCheck check2 = new SocketHealthCheck(this.bootstrap.props(), (UriBasedServiceInfo)new PlainServiceInfo("my-service-" + Version.get(), uri.toString()));
        Assertions.assertTrue((boolean)check2.execute().isHealthy());
        this.logger.debug(this.foo.toString());
    }
}

