/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.netflix.archaius.api.annotations.Configuration;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Channel;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SchedulingDiModule;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.ThrowableAction;
import com.turbospaces.common.TimedConfiguration;
import com.turbospaces.healthchecks.HttpHealthCheck;
import com.turbospaces.healthchecks.SocketHealthCheck;
import com.turbospaces.ups.PlainServiceInfo;
import io.jaegertracing.client.Version;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.Scheduled;

public class BootstrapTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        int port = PlatformUtil.findAvailableTcpPort();
        MockCloud cfg = MockCloud.newMock();
        cfg.appPort(port);
        cfg.withKafka(9092);
        URIBuilder uri = new URIBuilder().setScheme("http").setHost("localhost").setPath("/v1/status").setPort(port);
        ApplicationProperties props = new ApplicationProperties(cfg.build());
        SimpleBootstrap bootstrap = new SimpleBootstrap(props, new Class[]{AppConfig.class});
        bootstrap.addBootstrapRegistryInitializer((BootstrapRegistryInitializer)new HttpClientPlugin());
        bootstrap.addChannel((Channel)new InboundChannel(uri.build()));
        bootstrap.run(new String[0]);
        try {
            HttpHealthCheck check1 = new HttpHealthCheck(props, uri.build());
            Assertions.assertTrue((boolean)check1.execute().isHealthy());
            SocketHealthCheck check2 = new SocketHealthCheck(props, (UriBasedServiceInfo)new PlainServiceInfo("my-service-" + Version.get(), uri.toString()));
            Assertions.assertTrue((boolean)check2.execute().isHealthy());
            ((Foo)((Object)bootstrap.getBean(Foo.class))).toString();
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Configuration
    @Import(value={SchedulingDiModule.class, TimedConfiguration.class})
    public static class AppConfig {
        Logger logger = LoggerFactory.getLogger(this.getClass());

        @Bean
        public HttpFactory factory(HttpClientBuilder client) {
            return new HttpFactory(client);
        }

        @Bean
        public Foo foo(HttpFactory factory) throws Exception {
            return new Foo((CloseableHttpClient)factory.getObject());
        }

        @Scheduled(fixedRate=1000L)
        public void mock() {
            this.logger.info("The time is now {}", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date()));
        }
    }

    public static class HttpClientPlugin
    implements BootstrapRegistryInitializer {
        public void initialize(final BootstrapRegistry registry) {
            registry.register(HttpClientBuilder.class, BootstrapRegistry.InstanceSupplier.of((Object)HttpClients.custom()));
            registry.addCloseListener((ApplicationListener)new ApplicationListener<BootstrapContextClosedEvent>(){

                public void onApplicationEvent(BootstrapContextClosedEvent event) {
                    HttpClientBuilder builder = (HttpClientBuilder)registry.getRegisteredInstanceSupplier(HttpClientBuilder.class).get(event.getBootstrapContext());
                    ConfigurableApplicationContext ctx = event.getApplicationContext();
                    ctx.getBeanFactory().registerSingleton("http-client-factory", (Object)builder);
                }
            });
        }
    }

    public static class InboundChannel
    extends AbstractBootstrapAware
    implements Channel {
        private final URI uri;
        private ServerBootstrap http = ServerBootstrap.bootstrap();
        private HttpServer channel;
        @Inject
        CloseableHttpClient httpClient;

        public InboundChannel(URI uri) {
            this.uri = uri;
        }

        public void run(ApplicationArguments args) throws Exception {
            this.http = ServerBootstrap.bootstrap();
            this.http.setListenerPort(this.bootstrap.port());
            this.http.setHandlerMapper(new HttpRequestHandlerMapper(){

                public HttpRequestHandler lookup(HttpRequest request) {
                    return new HttpRequestHandler(){

                        public void handle(HttpRequest req, HttpResponse resp, HttpContext context) throws HttpException, IOException {
                            String reqUri = req.getRequestLine().getUri();
                            if (reqUri.equals(uri.getPath())) {
                                resp.setStatusCode(200);
                                resp.setEntity((HttpEntity)new StringEntity(req.toString(), ContentType.APPLICATION_JSON));
                            } else {
                                resp.setStatusCode(404);
                            }
                        }
                    };
                }
            });
            this.channel = this.http.create();
            this.channel.start();
            HttpGet req = new HttpGet();
            req.setURI(this.uri);
            final CountDownLatch latch = new CountDownLatch(1);
            try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
                final String text = EntityUtils.toString((HttpEntity)resp.getEntity());
                this.bootstrap.globalPlatform().work(new ThrowableAction(){

                    public void apply() throws Exception {
                        logger.debug(text);
                        latch.countDown();
                    }
                });
            }
            latch.await();
        }

        public void destroy() {
            if (this.channel != null) {
                this.channel.stop();
            }
        }
    }

    public static class Foo
    extends AbstractBootstrapAware {
        @Value(value="cloud.application.app-id")
        String appId;
        private final CloseableHttpClient client;

        @Inject
        public Foo(CloseableHttpClient client) {
            this.client = Objects.requireNonNull(client);
        }

        @Timed
        public void print() throws InterruptedException {
            final CountDownLatch l = new CountDownLatch(1);
            this.bootstrap.globalPlatform().execute(new Runnable(){

                @Override
                public void run() {
                    logger.debug(this.toString());
                    l.countDown();
                }
            });
            l.await();
        }

        public String toString() {
            ToStringBuilder toString = PlatformUtil.noClassNameToString((Object)((Object)this));
            return toString.append("appId", (Object)this.appId).append("client", (Object)this.client).append("version", (Object)this.bootstrap.release()).build();
        }
    }

    public static class HttpFactory
    extends AbstractFactoryBean<CloseableHttpClient> {
        private final HttpClientBuilder builder;

        public HttpFactory(HttpClientBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
        }

        public Class<?> getObjectType() {
            return CloseableHttpClient.class;
        }

        protected CloseableHttpClient createInstance() throws Exception {
            return this.builder.build();
        }

        protected void destroyInstance(CloseableHttpClient instance) throws Exception {
            instance.close();
        }
    }
}

