package com.turbospaces.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.ResolvableType;

public abstract class AbstractBootstrapAware implements BootstrapAware, BeanFactory {
    protected final Logger logger = LoggerFactory.getLogger(getClass());
    protected Bootstrap bootstrap;

    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
    @Override
    public Object getBean(String name) throws BeansException {
        return bootstrap.context().getBean(name);
    }
    @Override
    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return bootstrap.context().getBean(requiredType);
    }
    @Override
    public Object getBean(String name, Object... args) throws BeansException {
        return bootstrap.context().getBean(name, args);
    }
    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return bootstrap.context().getBean(requiredType);
    }
    @Override
    public <T> T getBean(Class<T> requiredType, Object... args) throws BeansException {
        return bootstrap.context().getBean(requiredType, args);
    }
    @Override
    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        return bootstrap.context().getBeanProvider(requiredType);
    }
    @Override
    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        return bootstrap.context().getBeanProvider(requiredType);
    }
    @Override
    public boolean containsBean(String name) {
        return bootstrap.context().containsBean(name);
    }
    @Override
    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return bootstrap.context().isSingleton(name);
    }
    @Override
    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return bootstrap.context().isPrototype(name);
    }
    @Override
    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return bootstrap.context().isTypeMatch(name, typeToMatch);
    }
    @Override
    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return bootstrap.context().isTypeMatch(name, typeToMatch);
    }
    @Override
    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return bootstrap.context().getType(name);
    }
    @Override
    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return bootstrap.context().getType(name, allowFactoryBeanInit);
    }
    @Override
    public String[] getAliases(String name) {
        return bootstrap.context().getAliases(name);
    }
}
