/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Throwables;
import com.turbospaces.boot.Channel;
import com.turbospaces.boot.ExecutionPlatform;
import com.turbospaces.boot.Platform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.ThrowableAction1;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentracing.Tracer;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.KeyStore;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.Cloud;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public interface Bootstrap
extends BeanFactory {
    public ConfigurableApplicationContext run(String ... var1);

    public void shutdown() throws Exception;

    public void exit(int var1);

    public Cloud cloud();

    public String spaceName();

    public String appId();

    public String release();

    public boolean isDevMode();

    public GenericApplicationContext context();

    public Platform globalPlatform();

    public ExecutionPlatform platform(String var1);

    public ApplicationProperties props();

    public ApplicationConfig cfg();

    public KeyStore keyStore();

    public void refreshCfg() throws Exception;

    public void squashLogging() throws Exception;

    public int port();

    public int secondaryPort();

    public int tertiaryPort();

    public MetricRegistry metricRegistry();

    public MeterRegistry meterRegistry();

    public HealthCheckRegistry healthCheckRegistry();

    public Tracer tracer();

    public boolean addChannel(Channel var1);

    public boolean isHealthy();

    public void registerHealthCheck(String var1, HealthCheck var2);

    default public Retry retry() {
        return this.props().retry(this.globalPlatform().scheduler());
    }

    default public <V> void retry(V value, ThrowableAction1<V> action) {
        this.retry(value, action, this.globalPlatform().scheduler());
    }

    default public <V> void retry(V value, final ThrowableAction1<V> action, Scheduler scheduler) {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        final AtomicLong seq = new AtomicLong();
        Mono.just(value).doOnError((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }).doOnNext(new Consumer<V>(){

            @Override
            public void accept(V target) {
                try {
                    action.apply(target);
                }
                catch (Exception err) {
                    logger.warn("got failure on iteration: " + seq.getAndIncrement(), (Throwable)err);
                    Throwables.throwIfUnchecked((Throwable)err);
                    throw new UndeclaredThrowableException(err);
                }
            }
        }).retryWhen(this.props().retry(scheduler)).block();
    }

    default public <V> void retry(Flux<V> stream, ThrowableAction1<List<V>> action) {
        this.retry(stream, action, this.globalPlatform().scheduler());
    }

    default public <V> void retry(Flux<V> stream, final ThrowableAction1<List<V>> action, Scheduler scheduler) {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        final AtomicLong seq = new AtomicLong();
        stream.collectList().doOnError((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }).doOnNext(new Consumer<List<V>>(){

            @Override
            public void accept(List<V> target) {
                try {
                    action.apply(target);
                }
                catch (Exception err) {
                    logger.warn("got failure on iteration: " + seq.getAndIncrement(), (Throwable)err);
                    Throwables.throwIfUnchecked((Throwable)err);
                    throw new UndeclaredThrowableException(err);
                }
            }
        }).retryWhen(this.props().retry(scheduler)).block();
    }

    default public <V> V retryCallable(Callable<V> callback) {
        return this.retryCallable(callback, Schedulers.immediate());
    }

    default public <V> V retryCallable(Callable<V> callback, Scheduler scheduler) {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        final MutableObject result = new MutableObject();
        final AtomicLong seq = new AtomicLong();
        Mono.just(callback).doOnError((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }).doOnNext(new Consumer<Callable<V>>(){

            @Override
            public void accept(Callable<V> target) {
                try {
                    Object value = target.call();
                    result.setValue(value);
                }
                catch (Exception err) {
                    logger.warn("got failure on iteration: " + seq.getAndIncrement(), (Throwable)err);
                    Throwables.throwIfUnchecked((Throwable)err);
                    throw new UndeclaredThrowableException(err);
                }
            }
        }).retryWhen(this.props().retry(scheduler)).block();
        return (V)result.getValue();
    }
}

