package com.turbospaces.ups;

import org.springframework.cloud.service.UriBasedServiceInfo;

import com.google.common.net.HostAndPort;

public class KafkaServiceInfo extends UriBasedServiceInfo {
    public static final String KAFKA_SCHEME = "kafka";

    public KafkaServiceInfo(String id, String uri) {
        super(id, uri);
    }
    public KafkaServiceInfo(String uri) {
        super(UPSs.KAFKA, uri);
    }
    public KafkaServiceInfo(String host, int port, String username, String password) {
        super(UPSs.KAFKA, KAFKA_SCHEME, host, port, username, password, null);
    }
    public KafkaServiceInfo(String host, int port) {
        super(UPSs.KAFKA, KAFKA_SCHEME, host, port, null, null, null);
    }
    public KafkaServiceInfo(HostAndPort hostAndPort) {
        super(UPSs.KAFKA, KAFKA_SCHEME, hostAndPort.getHost(), hostAndPort.getPort(), null, null, null);
    }
}
