package com.turbospaces.cfg;

import java.math.BigDecimal;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

import com.google.common.collect.Range;
import com.netflix.archaius.api.Property;

import reactor.core.scheduler.Scheduler;
import reactor.util.retry.Retry;

public interface TypedPropertyFactory {
    ApplicationConfig cfg();
    boolean warnInconsistency(String... cfgs) throws Exception;
    Retry retry(Scheduler scheduler);

    Property<List<Integer>> listOfInts(String key);
    Property<List<Long>> listOfLongs(String key);
    Property<List<String>> listOfStrings(String key);
    Property<List<Double>> listOfDoubles(String key);
    Property<List<BigDecimal>> listOfBigDecimals(String key);
    Property<List<LocalDate>> listOfLocalDates(String key);
    Property<List<Pattern>> listOfPatterns(String key);

    Property<Set<Integer>> setOfInts(String key);
    Property<Set<Long>> setOfLongs(String key);
    Property<Set<String>> setOfStrings(String key);
    Property<Set<Double>> setOfDoubles(String key);
    Property<Set<BigDecimal>> setOfBigDecimals(String key);
    Property<Set<LocalDate>> setOfLocalDates(String key);
    Property<Set<Pattern>> setOfPatterns(String key);

    Property<Duration> rangeValue(String key, Duration defaultValue, Range<Duration> boundaries);

    void analyze(URL url) throws Exception; // ~ offline

    String externalIp();
}
