/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.reflect.TypeToken;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.CloudOptions;
import com.turbospaces.cfg.DynamicPropertyFactory;
import com.turbospaces.cfg.TypedPropertyFactory;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.logging.ClassUtils;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scheduler.Scheduler;
import reactor.util.retry.Retry;

public class ApplicationProperties
implements TypedPropertyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationProperties.class);
    public static final String APPLICATION_PROPERTIES = "application.properties";
    public static final int PRIMARY_PORT = 8089;
    public static final int SECONDARY_PORT = 8091;
    public static final int TERTIARY_PORT = 8093;
    public final Property<String> CLOUD_APP_ID;
    public final Property<String> CLOUD_APP_SPACE_NAME;
    public final Property<String> CLOUD_APP_NAME;
    public final Property<String> CLOUD_APP_INSTANCE_INDEX;
    public final Property<String> CLOUD_APP_HOST;
    public final Property<Integer> CLOUD_APP_PORT;
    public final Property<Integer> CLOUD_APP_SECONDARY_PORT;
    public final Property<Integer> CLOUD_APP_TERTIARY_PORT;
    public final Property<Duration> CACHE_DEFAULT_MAX_TTL;
    public final Property<Duration> CACHE_DEFAULT_MAX_IDLE;
    public final Property<Integer> CACHE_DEFAULT_MAX_SIZE;
    public final Property<Boolean> CACHE_REPLICATED_NEVER_EXPIRE;
    public final Property<Boolean> CACHE_LOCAL_NEVER_EXPIRE;
    public final Property<Boolean> TCP_REUSE_ADDRESS;
    public final Property<Boolean> TCP_NO_DELAY;
    public final Property<Boolean> TCP_KEEP_ALIVE;
    public final Property<Duration> TCP_KEEP_ALIVE_TIMEOUT;
    public final Property<Duration> TCP_CONNECTION_TIMEOUT;
    public final Property<Duration> TCP_SOCKET_TIMEOUT;
    public final Property<Integer> TCP_SOCKET_BACKLOG;
    public final Property<Integer> TCP_FRAME_MAX_SIZE;
    public final Property<Integer> HTTP_POOL_MAX_SIZE;
    public final Property<Integer> NETTY_ACCEPTOR_POOL_SIZE;
    public final Property<Integer> NETTY_WORKER_POOL_SIZE;
    public final Property<Boolean> NETTY_VERSION_SEND_HTTP_HEADER;
    public final Property<String> NETTY_VERSION_HTTP_HEADER_NAME;
    public final Property<Integer> JETTY_POOL_MAX_SIZE;
    public final Property<Integer> JETTY_POOL_MIN_SIZE;
    public final Property<Integer> JETTY_POOL_QUEUE_MAX_SIZE;
    public final Property<Duration> JETTY_POOL_MAX_IDLE;
    public final Property<Boolean> JETTY_HTTP_SEND_DATE_HEADER;
    public final Property<Boolean> JETTY_GZIP_ENABLED;
    public final Property<List<String>> CORS_ALLOWED_ORIGINS;
    public final Property<List<String>> CORS_ALLOWED_HEADERS;
    public final Property<List<String>> CORS_ALLOWED_METHODS;
    public final Property<List<String>> CORS_EXPOSED_HEADERS;
    public final Property<Boolean> CORS_ALLOW_CREDENTIALS;
    public final Property<Duration> CORS_MAX_AGE;
    public final Property<Integer> JDBC_PERSIST_BATCH_SIZE;
    public final Property<Integer> JDBC_QUERY_BATCH_SIZE;
    public final Property<Integer> JDBC_LAZY_BATCH_SIZE;
    public final Property<Integer> JDBC_LAZY_SEQUENCE_BATCH_SIZE;
    public final Property<Integer> JDBC_POOL_MIN_SIZE;
    public final Property<Integer> JDBC_POOL_MAX_SIZE;
    public final Property<Integer> JDBC_READ_ONLY_POOL_MIN_SIZE;
    public final Property<Integer> JDBC_READ_ONLY_POOL_MAX_SIZE;
    public final Property<Duration> JDBC_CONNECTION_TIMEOUT;
    public final Property<Duration> KAFKA_MAX_BLOCK;
    public final Property<Boolean> KAFKA_IDEMPOTENCE_ENABLE;
    public final Property<String> KAFKA_ACKS;
    public final Property<String> KAFKA_COMPRESSION_TYPE;
    public final Property<Integer> KAFKA_RECORD_MAX_REQUEST_SIZE;
    public final Property<String> KAFKA_AUTO_OFFSET_RESET;
    public final Property<Duration> KAFKA_HEARTBEAT_INTERVAL;
    public final Property<Duration> KAFKA_SESSION_TIMEOUT;
    public final Property<Duration> KAFKA_POLL_MAX_INTERVAL;
    public final Property<Integer> KAFKA_POLL_MAX_RECORDS;
    public final Property<Integer> KAFKA_MIN_WORKERS;
    public final Property<Integer> KAFKA_MAX_WORKERS;
    public final Property<Integer> KAFKA_MAX_POLL_CONCURRENCY;
    public final Property<Boolean> KAFKA_SYSTEM_EXIT_ON_QUEUE_FULL;
    public final Property<Boolean> KAFKA_NACK_ON_QUEUE_FULL;
    public final Property<Integer> KAFKA_SYSTEM_EXIT_CODE;
    public final Property<Duration> KAFKA_SYSTEM_EXIT_DELAY;
    public final Property<String> QUARTZ_SCHEDULER_ID;
    public final Property<Integer> QUARTZ_WORKER_POOL_COUNT;
    public final Property<String> QUARTZ_JOBSTORE_TABLE_PREFIX;
    public final Property<Boolean> QUARTZ_JOBSTORE_USE_PROPS;
    public final Property<Boolean> QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK;
    public final Property<Integer> QUARTZ_CONNECTION_POOL_MIN;
    public final Property<Integer> QUARTZ_CONNECTION_POOL_MAX;
    public final Property<Boolean> QUARTZ_JOBSTORE_IS_CLUSTERED;
    public final Property<String> QUARTZ_INSTANCE_ID;
    public final Property<Duration> QUARTZ_AUTO_RECOVERY_INTERVAL;
    public final Property<Boolean> QUARTZ_SHUTDOWN_WAIT_FOR_JOBS_COMPLETION;
    public final Property<List<Pattern>> HTTP_METRICS_INBOUND_PATH_MASK;
    public final Property<List<Pattern>> HTTP_METRICS_OUTBOUND_PATH_MASK;
    public final Property<String> HTTP_METRICS_LATENCY_KEY;
    public final Property<String> HTTP_PROXY;
    public final Property<Integer> HTTP_POOL_MAX_PER_ROUTE;
    public final Property<List<Pattern>> HTTP_REQUEST_TO_PROXY_PATTERNS;
    public final Property<String> MOCK_HTTP_PROXY;
    public final Property<List<Pattern>> MOCK_HTTP_REQUEST_TO_PROXY_PATTERNS;
    public final Property<List<String>> HTTP_HEADERS_TO_MASK;
    public final Property<List<String>> HTTP_QUERY_PARAMS_TO_MASK;
    public final Property<List<String>> HTTP_COOKIES_TO_MASK;
    public final Property<Boolean> APP_DEV_MODE;
    public final Property<String> APP_DNS_QUERY;
    public final Property<Duration> APP_BACKOFF_RETRY_FIRST;
    public final Property<Duration> APP_BACKOFF_RETRY_MAX;
    public final Property<Integer> APP_BACKOFF_RETRY_NUM;
    public final Property<Boolean> APP_SENTRY_ENABLED;
    public final Property<Boolean> APP_USE_SELF_SIGNED_CERTIFICATE;
    public final Property<String> APP_LOGGING_RESET_TO;
    public final Property<Boolean> APP_LOGGING_DRY_RUN;
    public final Property<Boolean> APP_METRICS_DRY_RUN;
    public final Property<Boolean> APP_METRICS_ELK_REPORTER_ENABLED;
    public final Property<Boolean> APP_METRICS_INFLUX_REPORTER_ENABLED;
    public final Property<Boolean> APP_METRICS_PROMETHEUS_REPORTER_ENABLED;
    public final Property<Boolean> APP_ALERTS_DRY_RUN;
    public final Property<String> APP_EXTERNAL_IP;
    public final Property<String> APP_JMX_DOMAIN;
    public final Property<Boolean> APP_DB_MIGRATION_ENABLED;
    public final Property<String> APP_DB_MIGRATION_PATH;
    public final Property<Integer> APP_PLATFORM_POOL_SIZE;
    public final Property<Duration> APP_PLATFORM_MAX_IDLE;
    public final Property<Duration> APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT;
    public final Property<Duration> APP_TIMER_INTERVAL;
    public final Property<Integer> APP_METRICS_BULK_SIZE;
    public final Property<Boolean> APP_HEAP_DUMP_ON_OOM_ENABLED;
    public final Property<String> APP_HEAP_DUMP_DIR;
    public final Property<Boolean> APP_DATA_START_CLEAN;
    public final Property<Duration> APP_WAIT_FOR_HEALTHCHECKS_INTERVAL;
    public final Property<Boolean> APP_WAIT_FOR_HEALTHCHECKS_ENABLED;
    public final Property<Duration> APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT;
    public final Property<Boolean> APP_SHUTDOWN_HOOK_ENABLED;
    public final Property<Boolean> APP_CLEAR_CONFIG_AT_SHUTDOWN_ENABLED;
    public final Property<Boolean> APP_CFG_DYNAMIC_POLLING_ENABLED;
    public final Property<Boolean> SENTRY_ALERTS_FILTER_ENABLED;
    public final Property<List<Class<? extends Throwable>>> SENTRY_ALERTS_EX_CLASSES_TO_IGNORE;
    public final Property<List<String>> SENTRY_ALERTS_EX_MSGS_TO_IGNORE;
    public final Property<List<String>> SENTRY_ALERTS_EX_PATTERNS_TO_IGNORE;
    public final Property<List<String>> SENTRY_ALERTS_LOG_MESSAGES_TO_IGNORE;
    public final Property<List<String>> SENTRY_ALERTS_LOGGERS_TO_IGNORE;
    private final ApplicationConfig cfg;

    public ApplicationProperties(ApplicationConfig cfg) {
        this.cfg = Objects.requireNonNull(cfg);
        DynamicPropertyFactory pf = cfg.factory();
        this.CLOUD_APP_ID = pf.get("cloud.application.app-id", String.class).orElse((Object)System.getProperty("user.name"));
        this.CLOUD_APP_INSTANCE_INDEX = pf.get("cloud.application.instance_index", String.class).orElse((Object)"0");
        this.CLOUD_APP_NAME = pf.get("cloud.application.name", String.class);
        this.CLOUD_APP_SPACE_NAME = pf.get("cloud.application.space_name", String.class);
        this.CLOUD_APP_HOST = pf.get("cloud.application.host", String.class).orElse((Object)"localhost");
        this.CLOUD_APP_PORT = pf.get("cloud.application.port", Integer.TYPE).orElse((Object)8089);
        this.CLOUD_APP_SECONDARY_PORT = pf.get("cloud.application.secondary-port", Integer.TYPE).orElse((Object)8091);
        this.CLOUD_APP_TERTIARY_PORT = pf.get("cloud.application.tertiary-port", Integer.TYPE).orElse((Object)8093);
        this.CACHE_DEFAULT_MAX_TTL = pf.get("cache.default.max-ttl", Duration.class).orElse((Object)Duration.ofMinutes(60L));
        this.CACHE_DEFAULT_MAX_IDLE = pf.get("cache.default.max-idle", Duration.class).orElse((Object)Duration.ofMinutes(15L));
        this.CACHE_DEFAULT_MAX_SIZE = pf.get("cache.default.max-size", Integer.TYPE).orElse((Object)8192);
        this.CACHE_REPLICATED_NEVER_EXPIRE = pf.get("cache.replicated.never-expire", Boolean.TYPE).orElse((Object)true);
        this.CACHE_LOCAL_NEVER_EXPIRE = pf.get("cache.local.never-expire", Boolean.TYPE).orElse((Object)false);
        this.TCP_REUSE_ADDRESS = pf.get("tcp.reuse-address", Boolean.TYPE).orElse((Object)true);
        this.TCP_NO_DELAY = pf.get("tcp.no-delay", Boolean.TYPE).orElse((Object)true);
        this.TCP_KEEP_ALIVE = pf.get("tcp.keep-alive", Boolean.TYPE).orElse((Object)true);
        this.TCP_KEEP_ALIVE_TIMEOUT = this.rangeValue("tcp.keep-alive.timeout", Duration.ofMinutes(1L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(0L), (Comparable)Duration.ofMinutes(15L)));
        this.TCP_CONNECTION_TIMEOUT = this.rangeValue("tcp.connection.timeout", Duration.ofSeconds(15L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(0L), (Comparable)Duration.ofMinutes(1L)));
        this.TCP_SOCKET_TIMEOUT = this.rangeValue("tcp.socket.timeout", Duration.ofSeconds(60L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofMinutes(1L)));
        this.TCP_SOCKET_BACKLOG = pf.get("tcp.socket.backlog", Integer.TYPE).orElse((Object)1024);
        this.TCP_FRAME_MAX_SIZE = pf.get("tcp.frame.max-size", Integer.TYPE).orElse((Object)0x1000000);
        this.NETTY_ACCEPTOR_POOL_SIZE = pf.get("netty.acceptor-pool.size", Integer.TYPE).orElse((Object)Runtime.getRuntime().availableProcessors());
        this.NETTY_WORKER_POOL_SIZE = pf.get("netty.worker-pool.size", Integer.TYPE).orElse((Object)32);
        this.NETTY_VERSION_SEND_HTTP_HEADER = pf.get("netty.version.send-http-header", Boolean.TYPE).orElse((Object)false);
        this.NETTY_VERSION_HTTP_HEADER_NAME = pf.get("netty.version.http-header-name", String.class).orElse((Object)"X-Netty-Version");
        this.JETTY_POOL_MIN_SIZE = pf.get("jetty.pool.min-size", Integer.TYPE).orElse((Object)32);
        this.JETTY_POOL_MAX_SIZE = pf.get("jetty.pool.max-size", Integer.TYPE).orElse((Object)64);
        this.JETTY_POOL_QUEUE_MAX_SIZE = pf.get("jetty.pool.queue-max-size", Integer.TYPE).orElse((Object)16384);
        this.JETTY_POOL_MAX_IDLE = pf.get("jetty.pool.max-idle", Duration.class).orElse((Object)Duration.ofMinutes(1L));
        this.JETTY_HTTP_SEND_DATE_HEADER = pf.get("jetty.http.send-date-header", Boolean.TYPE).orElse((Object)true);
        this.JETTY_GZIP_ENABLED = pf.get("jetty.gzip.enabled", Boolean.TYPE).orElse((Object)true);
        this.CORS_ALLOWED_ORIGINS = this.listOfStrings("cors.allowed-origins");
        this.CORS_ALLOWED_HEADERS = this.listOfStrings("cors.allowed-headers").orElse(List.of("access-control-allow-origin", "content-type", "sentry-trace", "x-platform"));
        this.CORS_ALLOWED_METHODS = this.listOfStrings("cors.allowed-methods").orElse(List.of("GET", "POST", "DELETE", "PUT", "PATCH"));
        this.CORS_EXPOSED_HEADERS = this.listOfStrings("cors.exposed-headers").orElse(List.of("location"));
        this.CORS_ALLOW_CREDENTIALS = pf.get("cors.allow-credentials", Boolean.TYPE).orElse((Object)true);
        this.CORS_MAX_AGE = this.rangeValue("cors.max-age", Duration.ofMinutes(1L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(15L), (Comparable)Duration.ofHours(1L)));
        this.JDBC_PERSIST_BATCH_SIZE = pf.get("jdbc.persist-batch.size", Integer.TYPE).orElse((Object)100);
        this.JDBC_QUERY_BATCH_SIZE = pf.get("jdbc.query-batch.size", Integer.TYPE).orElse((Object)250);
        this.JDBC_LAZY_BATCH_SIZE = pf.get("jdbc.lazy-batch.size", Integer.TYPE).orElse((Object)100);
        this.JDBC_LAZY_SEQUENCE_BATCH_SIZE = pf.get("jdbc.lazy-sequence-batch.size", Integer.TYPE).orElse((Object)1000);
        this.JDBC_POOL_MIN_SIZE = pf.get("jdbc.pool.min-size", Integer.TYPE).orElse((Object)1);
        this.JDBC_POOL_MAX_SIZE = pf.get("jdbc.pool.max-size", Integer.TYPE).orElse((Object)10);
        this.JDBC_READ_ONLY_POOL_MIN_SIZE = pf.get("jdbc.read-only-pool.min-size", Integer.TYPE).orElse((Object)1);
        this.JDBC_READ_ONLY_POOL_MAX_SIZE = pf.get("jdbc.read-only-pool.max-size", Integer.TYPE).orElse((Object)5);
        this.JDBC_CONNECTION_TIMEOUT = this.rangeValue("jdbc.connection.timeout", Duration.ofSeconds(30L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(15L), (Comparable)Duration.ofMinutes(1L)));
        this.KAFKA_MAX_BLOCK = this.rangeValue("kafka.max-block", Duration.ofSeconds(30L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(15L), (Comparable)Duration.ofMinutes(1L)));
        this.KAFKA_IDEMPOTENCE_ENABLE = pf.get("kafka.idempotence.enable", Boolean.TYPE).orElse((Object)true);
        this.KAFKA_ACKS = pf.get("kafka.acks", String.class).orElse((Object)"all");
        this.KAFKA_COMPRESSION_TYPE = pf.get("kafka.compression.type", String.class).orElse((Object)"none");
        this.KAFKA_RECORD_MAX_REQUEST_SIZE = pf.get("kafka.record.max-request-size", Integer.TYPE).orElse((Object)0x400000);
        this.KAFKA_AUTO_OFFSET_RESET = pf.get("kafka.auto.offset.reset", String.class);
        this.KAFKA_HEARTBEAT_INTERVAL = this.rangeValue("kafka.heartbeat.interval", Duration.ofSeconds(5L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofSeconds(15L)));
        this.KAFKA_SESSION_TIMEOUT = this.rangeValue("kafka.session.timeout", Duration.ofSeconds(30L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(15L), (Comparable)Duration.ofMinutes(1L)));
        this.KAFKA_POLL_MAX_INTERVAL = this.rangeValue("kafka.poll.max-interval", Duration.ofMinutes(10L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(15L), (Comparable)Duration.ofMinutes(30L)));
        this.KAFKA_POLL_MAX_RECORDS = pf.get("kafka.poll.max-records", Integer.TYPE).orElse((Object)1024);
        this.KAFKA_MIN_WORKERS = pf.get("kafka.min-workers", Integer.TYPE).orElse((Object)16);
        this.KAFKA_MAX_WORKERS = pf.get("kafka.max-workers", Integer.TYPE).orElse((Object)128);
        this.KAFKA_MAX_POLL_CONCURRENCY = pf.get("kafka.max-poll-concurrency", Integer.TYPE).orElse((Object)4);
        this.KAFKA_NACK_ON_QUEUE_FULL = pf.get("kafka.nack.on-queue-full", Boolean.TYPE).orElse((Object)false);
        this.KAFKA_SYSTEM_EXIT_ON_QUEUE_FULL = pf.get("kafka.system-exit.on-queue-full", Boolean.TYPE).orElse((Object)true);
        this.KAFKA_SYSTEM_EXIT_CODE = pf.get("kafka.system-exit.code", Integer.TYPE).orElse((Object)-1);
        this.KAFKA_SYSTEM_EXIT_DELAY = this.rangeValue("kafka.system-exit.delay", Duration.ofSeconds(5L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofMinutes(1L)));
        this.QUARTZ_SCHEDULER_ID = pf.get("quartz.scheduler.id", String.class).orElse((Object)"AUTO");
        this.QUARTZ_WORKER_POOL_COUNT = pf.get("quartz.worker-pool.count", Integer.class).orElse((Object)8);
        this.QUARTZ_JOBSTORE_TABLE_PREFIX = pf.get("quartz.jobstore.table-prefix", String.class).orElse((Object)"qrtz_");
        this.QUARTZ_JOBSTORE_USE_PROPS = pf.get("quartz.jobstore.use-props", Boolean.class).orElse((Object)false);
        this.QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK = pf.get("quartz.jobstore.acquire-triggers-within-lock", Boolean.class).orElse((Object)false);
        this.QUARTZ_JOBSTORE_IS_CLUSTERED = pf.get("quartz.jobstore.is-clustered", Boolean.class).orElse((Object)false);
        this.QUARTZ_CONNECTION_POOL_MIN = pf.get("quartz.connection-pool.min", Integer.class).orElse((Object)1);
        this.QUARTZ_CONNECTION_POOL_MAX = pf.get("quartz.connection-pool.max", Integer.class).orElse((Object)5);
        this.QUARTZ_INSTANCE_ID = pf.get("quartz.instance.id", String.class);
        this.QUARTZ_AUTO_RECOVERY_INTERVAL = pf.get("quartz.auto-recovery.interval", Duration.class).orElse((Object)Duration.ofHours(1L));
        this.QUARTZ_SHUTDOWN_WAIT_FOR_JOBS_COMPLETION = pf.get("quartz.shutdown.wait-for-jobs-completion", Boolean.TYPE);
        this.APP_DEV_MODE = pf.get("app.dev.mode", Boolean.TYPE).orElse((Object)true);
        this.APP_DNS_QUERY = pf.get("app.dns.query", String.class);
        this.APP_BACKOFF_RETRY_FIRST = this.rangeValue("app.backoff-retry.first", Duration.ofSeconds(1L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofMinutes(1L)));
        this.APP_BACKOFF_RETRY_MAX = this.rangeValue("app.backoff-retry.max", Duration.ofSeconds(30L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(15L), (Comparable)Duration.ofMinutes(1L)));
        this.APP_BACKOFF_RETRY_NUM = pf.get("app.backoff-retry.num", Integer.TYPE).orElse((Object)10);
        this.APP_SENTRY_ENABLED = pf.get("app.sentry.enabled", Boolean.TYPE).orElse((Object)true);
        this.APP_USE_SELF_SIGNED_CERTIFICATE = pf.get("app.use.self-signed-certificate", Boolean.TYPE).orElse((Object)false);
        this.APP_LOGGING_RESET_TO = pf.get("app.logging.reset-to", String.class);
        this.APP_LOGGING_DRY_RUN = pf.get("app.logging.dry-run", Boolean.TYPE).orElse((Object)false);
        this.APP_METRICS_DRY_RUN = pf.get("app.metrics.dry-run", Boolean.TYPE).orElse((Object)false);
        this.APP_METRICS_ELK_REPORTER_ENABLED = pf.get("app.metrics.elk-reporter.enabled", Boolean.TYPE).orElse((Object)false);
        this.APP_METRICS_INFLUX_REPORTER_ENABLED = pf.get("app.metrics.influx-reporter.enabled", Boolean.TYPE).orElse((Object)true);
        this.APP_METRICS_PROMETHEUS_REPORTER_ENABLED = pf.get("app.metrics.prometheus-reporter.enabled", Boolean.TYPE).orElse((Object)true);
        this.APP_ALERTS_DRY_RUN = pf.get("app.alerts.dry-run", Boolean.TYPE).orElse((Object)false);
        this.APP_EXTERNAL_IP = pf.get("app.external.ip", String.class).orElse((Object)PlatformUtil.fetchExternalIp(this));
        this.APP_JMX_DOMAIN = pf.get("app.jmx.domain", String.class).orElse((Object)"metrics");
        this.APP_DB_MIGRATION_ENABLED = pf.get("app.db-migration.enabled", Boolean.TYPE).orElse((Object)true);
        this.APP_DB_MIGRATION_PATH = pf.get("app.db-migration.path", String.class).orElse((Object)"db/sql-migration");
        this.APP_PLATFORM_POOL_SIZE = pf.get("app.platform.pool-size", Integer.TYPE).orElse((Object)64);
        this.APP_PLATFORM_MAX_IDLE = this.rangeValue("app.platform.max-idle", Duration.ofMinutes(1L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofHours(1L)));
        this.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT = this.rangeValue("app.platform.graceful-shutdown-timeout", Duration.ofSeconds(30L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofMinutes(1L)));
        this.APP_TIMER_INTERVAL = this.rangeValue("app.timer.interval", Duration.ofSeconds(15L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofMinutes(1L)));
        this.APP_METRICS_BULK_SIZE = pf.get("app.metrics.bulk-size", Integer.TYPE).orElse((Object)1024);
        this.APP_HEAP_DUMP_ON_OOM_ENABLED = pf.get("app.heap-dump-on-oom.enabled", Boolean.TYPE).orElse((Object)true);
        this.APP_HEAP_DUMP_DIR = pf.get("app.heap-dump.dir", String.class).orElse((Object)System.getProperty("java.io.tmpdir"));
        this.APP_WAIT_FOR_HEALTHCHECKS_INTERVAL = this.rangeValue("app.wait-for-healthchecks.interval", Duration.ofSeconds(1L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(1L), (Comparable)Duration.ofMinutes(1L)));
        this.APP_WAIT_FOR_HEALTHCHECKS_ENABLED = pf.get("app.wait-for-healthchecks.enabled", Boolean.TYPE).orElse((Object)false);
        this.APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT = this.rangeValue("app.wait-for-healthchecks.timeout", Duration.ofSeconds(60L), (Range<Duration>)Range.closed((Comparable)Duration.ofSeconds(15L), (Comparable)Duration.ofMinutes(5L)));
        this.APP_DATA_START_CLEAN = pf.get("app.data.start-clean", Boolean.TYPE).orElse((Object)false);
        this.APP_SHUTDOWN_HOOK_ENABLED = pf.get("app.shutdown-hook.enabled", Boolean.TYPE).orElse((Object)true);
        this.APP_CLEAR_CONFIG_AT_SHUTDOWN_ENABLED = pf.get("app.clear-config-at-shutdown.enabled", Boolean.TYPE).orElse((Object)false);
        this.APP_CFG_DYNAMIC_POLLING_ENABLED = pf.get("app.cfg-dynamic-polling.enabled", Boolean.TYPE).orElse((Object)true);
        this.HTTP_POOL_MAX_PER_ROUTE = pf.get("http.pool.max-per-route", Integer.TYPE).orElse((Object)32);
        this.HTTP_POOL_MAX_SIZE = pf.get("http.pool.max-size", Integer.TYPE).orElse((Object)256);
        this.HTTP_METRICS_LATENCY_KEY = pf.get("http.metrics.latency-key", String.class).orElse((Object)"server-latency");
        this.HTTP_HEADERS_TO_MASK = this.listOfStrings("http.headers.to-mask").orElse(List.of("Authorization", "X-Api-Key"));
        this.HTTP_COOKIES_TO_MASK = this.listOfStrings("http.cookies.to-mask");
        this.HTTP_QUERY_PARAMS_TO_MASK = this.listOfStrings("http.query-params.to-mask").orElse(List.of("password"));
        this.HTTP_METRICS_INBOUND_PATH_MASK = this.listOfPatterns("http.metrics.inbound-path-mask");
        this.HTTP_METRICS_OUTBOUND_PATH_MASK = this.listOfPatterns("http.metrics.outbound-path-mask");
        this.HTTP_PROXY = pf.get("http.proxy", String.class);
        this.HTTP_REQUEST_TO_PROXY_PATTERNS = this.listOfPatterns("http.request-to-proxy.patterns");
        this.MOCK_HTTP_PROXY = pf.get("mock.http.proxy", String.class);
        this.MOCK_HTTP_REQUEST_TO_PROXY_PATTERNS = this.listOfPatterns("mock.http.request-to-proxy.patterns");
        this.SENTRY_ALERTS_FILTER_ENABLED = pf.get("sentry.alerts-filter.enabled", Boolean.TYPE).orElse((Object)true);
        this.SENTRY_ALERTS_EX_CLASSES_TO_IGNORE = pf.getProperty("sentry.alerts.ex.classes.to.ignore").asType(s -> ClassUtils.parseThrowableClasses((String)s, (String)","), "");
        this.SENTRY_ALERTS_EX_MSGS_TO_IGNORE = pf.getProperty("sentry.alerts.ex.msgs.to.ignore").asType(s -> this.splitString((String)s, "~"), "");
        this.SENTRY_ALERTS_EX_PATTERNS_TO_IGNORE = pf.getProperty("sentry.alerts.ex.patterns.to.ignore").asType(s -> this.splitString((String)s, "~"), "");
        this.SENTRY_ALERTS_LOG_MESSAGES_TO_IGNORE = pf.getProperty("sentry.alerts.log.messages.to.ignore").asType(s -> this.splitString((String)s, "~"), "");
        this.SENTRY_ALERTS_LOGGERS_TO_IGNORE = pf.getProperty("sentry.alerts.loggers.to.ignore").asType(s -> this.splitString((String)s, "~"), "");
    }

    protected List<Pattern> parsePatterns(String patterns) {
        try {
            return patterns.isEmpty() ? Collections.emptyList() : Arrays.stream(patterns.split(",")).map(Pattern::compile).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("Error on patter init {}", (Object)patterns, (Object)e);
            return Collections.emptyList();
        }
    }

    protected List<String> splitString(String value, String separator) {
        try {
            return value.trim().isEmpty() ? Collections.emptyList() : Arrays.asList(value.split(separator));
        }
        catch (Exception e) {
            LOGGER.error("Error on string list parse {}", (Object)value);
            return Collections.emptyList();
        }
    }

    @Override
    public ApplicationConfig cfg() {
        return this.cfg;
    }

    @Override
    public Property<Duration> rangeValue(String key, Duration defaultValue, final Range<Duration> boundary) {
        final Property prop = this.cfg.factory().get(key, Duration.class).orElse((Object)defaultValue);
        if (Objects.nonNull(boundary)) {
            prop.subscribe((Consumer)new Consumer<Duration>(){

                @Override
                public void accept(Duration t) {
                    if (Objects.nonNull(t) && boundary.contains((Comparable)t)) {
                        LOGGER.error("property: {} is out of range: {}, new value: {}", new Object[]{prop.getKey(), boundary, t});
                    }
                }
            });
            LOGGER.debug("subscribed to: {} and will monitor value of range: {}", (Object)prop.getKey(), boundary);
        }
        return prop;
    }

    @Override
    public Retry retry(Scheduler scheduler) {
        int numRetries = (Integer)this.APP_BACKOFF_RETRY_NUM.get();
        Duration firstBackoff = (Duration)this.APP_BACKOFF_RETRY_FIRST.get();
        Duration maxBackoff = (Duration)this.APP_BACKOFF_RETRY_MAX.get();
        return Retry.backoff((long)numRetries, (Duration)firstBackoff).maxBackoff(maxBackoff).scheduler(scheduler);
    }

    @Override
    public Property<List<Integer>> listOfInts(String key) {
        TypeToken<List<Integer>> type = new TypeToken<List<Integer>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<List<Long>> listOfLongs(String key) {
        TypeToken<List<Long>> type = new TypeToken<List<Long>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<List<String>> listOfStrings(String key) {
        TypeToken<List<String>> type = new TypeToken<List<String>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<List<Double>> listOfDoubles(String key) {
        TypeToken<List<Double>> type = new TypeToken<List<Double>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<List<BigDecimal>> listOfBigDecimals(String key) {
        TypeToken<List<BigDecimal>> type = new TypeToken<List<BigDecimal>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<Set<LocalDate>> setOfLocalDates(String key) {
        TypeToken<Set<LocalDate>> type = new TypeToken<Set<LocalDate>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<Set<Pattern>> setOfPatterns(String key) {
        TypeToken<Set<Pattern>> type = new TypeToken<Set<Pattern>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<Set<Integer>> setOfInts(String key) {
        TypeToken<Set<Integer>> type = new TypeToken<Set<Integer>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<Set<Long>> setOfLongs(String key) {
        TypeToken<Set<Long>> type = new TypeToken<Set<Long>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<Set<String>> setOfStrings(String key) {
        TypeToken<Set<String>> type = new TypeToken<Set<String>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<Set<Double>> setOfDoubles(String key) {
        TypeToken<Set<Double>> type = new TypeToken<Set<Double>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<Set<BigDecimal>> setOfBigDecimals(String key) {
        TypeToken<Set<BigDecimal>> type = new TypeToken<Set<BigDecimal>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<List<LocalDate>> listOfLocalDates(String key) {
        TypeToken<List<LocalDate>> type = new TypeToken<List<LocalDate>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public Property<List<Pattern>> listOfPatterns(String key) {
        TypeToken<List<Pattern>> type = new TypeToken<List<Pattern>>(){};
        Class rawType = type.getRawType();
        return this.cfg.factory().get(key, type.getType()).map(rawType::cast);
    }

    @Override
    public boolean warnInconsistency(String ... cfgs) throws Exception {
        boolean toReturn = false;
        ImmutableList l = ArrayUtils.isEmpty((Object[])cfgs) ? ImmutableList.of((Object)APPLICATION_PROPERTIES) : ImmutableList.copyOf((Object[])cfgs);
        DefaultCompositeConfig gitComposeConfig = (DefaultCompositeConfig)this.cfg.getConfig("core.GIT_CFG");
        Map<String, Object> map = this.readValues();
        for (String next : l) {
            Path path = Paths.get((String)this.CLOUD_APP_ID.get(), next);
            DefaultSettableConfig config = (DefaultSettableConfig)gitComposeConfig.getConfig(path.toString());
            if (!Objects.nonNull(config)) continue;
            Iterator it = config.getKeys();
            ArrayList unknowns = Lists.newArrayList();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!BooleanUtils.isFalse((Boolean)map.containsKey(key))) continue;
                unknowns.add(key);
                toReturn = true;
            }
            if (!BooleanUtils.isFalse((Boolean)unknowns.isEmpty())) continue;
            LOGGER.error("unknown keys: {} in {}", (Object)unknowns, map.keySet());
        }
        return toReturn;
    }

    @Override
    public void analyze(URL url) throws Exception {
        Map<String, Object> map = this.readValues();
        Properties table = new Properties();
        try (InputStream io = url.openStream();){
            table.load(io);
        }
        for (Map.Entry<Object, Object> it : table.entrySet()) {
            String key = it.getKey().toString();
            String value = it.getValue().toString();
            if (BooleanUtils.isFalse((Boolean)map.containsKey(key))) {
                System.err.println(String.format("unknown: %s", key));
                continue;
            }
            String toString = Objects.toString(map.get(key));
            if (!Objects.equals(toString, value)) continue;
            System.out.println(String.format("toRemove: %s", key));
        }
    }

    protected Map<String, Object> readValues() throws IllegalAccessException {
        Field[] fields;
        HashMap map = Maps.newHashMap();
        for (Field f : fields = FieldUtils.getAllFields(this.getClass())) {
            if (!Modifier.isPublic(f.getModifiers()) || !BooleanUtils.isFalse((Boolean)Modifier.isStatic(f.getModifiers()))) continue;
            Property prop = (Property)FieldUtils.readField((Field)f, (Object)this);
            String key = prop.getKey();
            Object value = prop.get();
            map.put(key, value);
        }
        Arrays.asList(FieldUtils.getAllFields(CloudOptions.class)).stream().map(Field::getName).forEach(map::remove);
        return map;
    }
}

