package com.turbospaces.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.apache.commons.lang3.StringUtils;

@Target({ ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ApiEndpoint {
    public static final String HEADER_TRACE_PARENT = "Traceparent";

    String traceHeader() default StringUtils.EMPTY;
    String metricsUri() default StringUtils.EMPTY;
    String[] headersToMask() default {};
    String[] queryParamsToMask() default {};
    boolean doNotPrintRequestBody() default false;
    String ipWhitelistKey() default StringUtils.EMPTY;
}
