/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.netflix.archaius.api.Property;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SocketUtils;

public abstract class PlatformUtil {
    private static final Logger LOGGER;
    public static final Map<String, String> ISO2_CODES;
    public static final Map<String, String> ISO3_CODES;

    public static InetSocketAddress address(ApplicationConfig cfg) {
        String ip = cfg.getString("cloud.application.host");
        int port = cfg.getInteger("cloud.application.port");
        return new InetSocketAddress(ip, port);
    }

    public static InetSocketAddress address(Properties props) {
        String ip = props.get("cloud.application.host").toString();
        String port = props.get("cloud.application.port").toString();
        return new InetSocketAddress(ip, Integer.parseInt(port));
    }

    public static List<String> readStaticConstants(Class<?> type) throws IllegalAccessException {
        Field[] fields;
        Preconditions.checkArgument((boolean)type.isInterface());
        LinkedList l = Lists.newLinkedList();
        for (Field f : fields = FieldUtils.getAllFields(type)) {
            if (!Modifier.isPublic(f.getModifiers()) || !BooleanUtils.isTrue((Boolean)Modifier.isStatic(f.getModifiers()))) continue;
            String key = (String)FieldUtils.readStaticField((Field)f);
            l.add(key);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> jarVersion(Class<?> clazz) {
        try (InputStream stream = clazz.getClassLoader().getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(stream);
            Attributes attributes = manifest.getMainAttributes();
            String version = attributes.getValue("Implementation-Version");
            if (version != null) {
                Optional<String> optional = Optional.of(version);
                return optional;
            }
        }
        catch (Exception err) {
            LOGGER.trace(err.getMessage(), (Throwable)err);
        }
        String version = clazz.getPackage().getImplementationVersion();
        if (version != null) {
            return Optional.of(version);
        }
        try {
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (location.getFile() == null) return Optional.empty();
            return PlatformUtil.jarVersion(new File(location.getFile()));
        }
        catch (Exception err) {
            LOGGER.trace(err.getMessage(), (Throwable)err);
        }
        return Optional.empty();
    }

    public static Optional<String> jarVersion(File f) throws IOException {
        try (JarFile jar = new JarFile(f);){
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String impVersion = attributes.getValue("Implementation-Version");
            if (impVersion != null) {
                Optional<String> optional = Optional.of(impVersion);
                return optional;
            }
        }
        return Optional.empty();
    }

    public static String version(Property<String> prop) {
        Optional<String> opt;
        String[] split;
        String appName = (String)prop.get();
        if (StringUtils.isNotEmpty((CharSequence)appName) && (split = appName.split(":")).length == 3) {
            String groupId = split[0];
            String artifactId = split[1];
            String version = split[2];
            if (StringUtils.isNotEmpty((CharSequence)groupId) && StringUtils.isNotEmpty((CharSequence)artifactId)) {
                return version;
            }
        }
        if ((opt = PlatformUtil.jarVersion(PlatformUtil.class)).isPresent()) {
            return opt.get();
        }
        return "latest".toUpperCase().intern();
    }

    public static List<Runnable> shutdownExecutor(ExecutorService executor, Duration timeout) {
        List<Runnable> runnables = Collections.emptyList();
        executor.shutdown();
        try {
            boolean allCompleted = executor.awaitTermination(timeout.toSeconds(), TimeUnit.SECONDS);
            if (BooleanUtils.isFalse((Boolean)allCompleted)) {
                runnables = executor.shutdownNow();
                LOGGER.debug("listing {} tasks that never commenced execution ...", (Object)runnables.size());
                for (Runnable runnable : runnables) {
                    LOGGER.debug(runnable.toString());
                }
            }
        }
        catch (InterruptedException ie) {
            LOGGER.debug(ie.getMessage(), (Throwable)ie);
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        return runnables;
    }

    public static String detectIp() {
        String string;
        block10: {
            DatagramChannel channel = DatagramChannel.open().connect(new InetSocketAddress("8.8.8.8", 1));
            try {
                string = ((InetSocketAddress)channel.getLocalAddress()).getHostString();
                if (channel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception err) {
                    LOGGER.debug(err.getMessage(), (Throwable)err);
                    try {
                        return InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            channel.close();
        }
        return string;
    }

    public static String fetchExternalIp(ApplicationProperties props) {
        try {
            URI uri = new URI("http://checkip.amazonaws.com");
            HttpURLConnection con = (HttpURLConnection)uri.toURL().openConnection();
            con.setRequestMethod("GET");
            con.setConnectTimeout((int)((Duration)props.TCP_CONNECTION_TIMEOUT.get()).toMillis());
            con.setReadTimeout((int)((Duration)props.TCP_SOCKET_TIMEOUT.get()).toMillis());
            StringBuilder sb = new StringBuilder();
            try (InputStream io = con.getInputStream();
                 BufferedReader br = new BufferedReader(new InputStreamReader(io));){
                String output;
                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }
            }
            return sb.toString();
        }
        catch (Exception err) {
            LOGGER.debug(err.getMessage(), (Throwable)err);
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static int findAvailableTcpPort() {
        return SocketUtils.findAvailableTcpPort();
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(LocalDateTime date) {
        return Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalUTCDate() {
        return PlatformUtil.toLocalUTCDate(new Date());
    }

    public static LocalDate toLocalUTCDate(Date date) {
        return date.toInstant().atOffset(ZoneOffset.UTC).toLocalDate();
    }

    public static ToStringBuilder noClassNameToString(Object obj) {
        return new ToStringBuilder(obj, ToStringStyle.NO_CLASS_NAME_STYLE);
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<T> predicate) {
        return StreamSupport.stream(new PredicateSpliterator(stream.spliterator(), predicate), false);
    }

    private PlatformUtil() {
    }

    static {
        Locale locale;
        LOGGER = LoggerFactory.getLogger(PlatformUtil.class);
        String[] countries = Locale.getISOCountries();
        HashMap<String, String> m = new HashMap<String, String>(countries.length);
        for (String country : countries) {
            locale = new Locale("", country);
            m.put(country, locale.getISO3Country().toUpperCase());
        }
        ISO2_CODES = ImmutableMap.copyOf(m);
        countries = Locale.getISOCountries();
        m = new HashMap(countries.length);
        for (String country : countries) {
            locale = new Locale("", country);
            m.put(locale.getISO3Country().toUpperCase(), locale.getCountry().toUpperCase());
        }
        ISO3_CODES = ImmutableMap.copyOf(m);
    }

    public static class PredicateSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Spliterator<T> spliterator;
        private final Predicate<T> predicate;
        private boolean active = true;

        public PredicateSpliterator(Spliterator<T> spliterator, Predicate<T> predicate) {
            super(spliterator.estimateSize(), 1024);
            this.spliterator = spliterator;
            this.predicate = predicate;
        }

        @Override
        public boolean tryAdvance(final Consumer<? super T> consumer) {
            if (this.active) {
                boolean hasNext = this.spliterator.tryAdvance(new Consumer<T>(){

                    @Override
                    public void accept(T t) {
                        if (predicate.test(t)) {
                            consumer.accept(t);
                        } else {
                            active = false;
                        }
                    }
                });
                return hasNext && this.active;
            }
            return false;
        }
    }
}

