/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.boot.AbstractPlatform;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.executor.Executors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public class ConfigurablePlatform
extends AbstractPlatform {
    private final ExecutorService executor;

    public ConfigurablePlatform(String name, ApplicationProperties props, MeterRegistry meter) {
        super(props);
        ThreadFactoryBuilder factory = new ThreadFactoryBuilder();
        factory.setDaemon(false);
        factory.setNameFormat(name + "-%d");
        ThreadFactory threadFactory = factory.build();
        int minPoolSize = props.cfg().getInteger(name + "pool.min-size", 4);
        int maxPoolSize = props.cfg().getInteger(name + "pool.max-size", (Integer)props.APP_PLATFORM_POOL_SIZE.get());
        Duration ttl = (Duration)props.APP_PLATFORM_MAX_IDLE.get();
        ExecutorService pool = Executors.newScalingThreadPool(minPoolSize, maxPoolSize, ttl, threadFactory);
        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics(pool, name, Collections.emptyList());
        metrics.bindTo(meter);
        this.executor = pool;
    }

    @Override
    public ExecutorService executor() {
        return this.executor;
    }
}

