/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.netflix.archaius.api.Config;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.SSL;
import com.turbospaces.ups.H2ServiceInfo;
import com.turbospaces.ups.HsqlServiceInfo;
import com.turbospaces.ups.MariaDBServiceInfo;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.RawServiceInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.CloudConnector;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.app.BasicApplicationInstanceInfo;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.common.MysqlServiceInfo;
import org.springframework.cloud.service.common.OracleServiceInfo;
import org.springframework.cloud.service.common.PostgresqlServiceInfo;
import org.springframework.cloud.service.common.RedisServiceInfo;

public class ConfigurableCloudConnector
implements CloudConnector {
    public static final String RANDOM = "random";
    public static final String FILE_SUFFIX = "_FILE";
    public static final String ENV_UPS_PREFIX = "UPS_";
    public static final String ENV_CACERT_PREFIX = "CACERT_";
    public static final String ENV_HOSTNAME = "HOSTNAME";
    public static final String ENV_SPACE_NAME = "SPACE_NAME";
    public static final String INDEX = "INDEX";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ServiceInfo> services;
    private final BasicApplicationInstanceInfo instanceInfo;
    private String spaceName;
    private String appId;
    private String instanceId;

    public ConfigurableCloudConnector(ApplicationProperties props, KeyStore keyStore) throws Exception {
        HashMap<String, ServiceInfo> l = new HashMap<String, ServiceInfo>();
        HashMap<String, Object> cloudProps = new HashMap<String, Object>();
        this.configureInstance(props);
        this.configureAddress(props, cloudProps);
        this.configureSlot(props, cloudProps);
        this.configureSiteName(props, cloudProps);
        this.configureAppName(props, cloudProps);
        this.configureServices(props, keyStore, l);
        this.instanceInfo = new BasicApplicationInstanceInfo(this.instanceId, this.appId, cloudProps);
        this.services = ImmutableList.copyOf(l.values());
        for (ServiceInfo si : this.services) {
            this.logger.debug("adding ups('{}')={}", (Object)si.getId(), (Object)si);
        }
    }

    public boolean isInMatchingCloud() {
        boolean isMatching = StringUtils.isNotEmpty((CharSequence)this.spaceName) && StringUtils.isNotEmpty((CharSequence)this.appId);
        this.logger.info("isMatching(spaceName={}, appId={}) = [{}]", new Object[]{this.spaceName, this.appId, isMatching});
        return isMatching;
    }

    public ApplicationInstanceInfo getApplicationInstanceInfo() {
        return this.instanceInfo;
    }

    public List<ServiceInfo> getServiceInfos() {
        return this.services;
    }

    private void configureAddress(ApplicationProperties props, Map<String, Object> cloudProps) throws IOException {
        ApplicationConfig cfg = props.cfg();
        String hostname = PlatformUtil.detectIp();
        if (cfg.containsKey("cloud.application.host")) {
            hostname = cfg.getString("cloud.application.host");
        }
        int primaryPort = 8089;
        if (cfg.containsKey("cloud.application.port")) {
            primaryPort = RANDOM.equalsIgnoreCase(cfg.getString("cloud.application.port")) ? PlatformUtil.findAvailableTcpPort() : cfg.getInteger("cloud.application.port");
        }
        int secondaryPort = 8091;
        if (cfg.containsKey("cloud.application.secondary-port")) {
            secondaryPort = RANDOM.equalsIgnoreCase(cfg.getString("cloud.application.secondary-port")) ? PlatformUtil.findAvailableTcpPort() : cfg.getInteger("cloud.application.secondary-port");
        }
        int tertiaryPort = 8093;
        if (cfg.containsKey("cloud.application.tertiary-port")) {
            tertiaryPort = RANDOM.equalsIgnoreCase(cfg.getString("cloud.application.tertiary-port")) ? PlatformUtil.findAvailableTcpPort() : cfg.getInteger("cloud.application.tertiary-port");
        }
        if (StringUtils.isNotEmpty((CharSequence)System.getenv(ENV_HOSTNAME))) {
            hostname = System.getenv(ENV_HOSTNAME);
        }
        this.addCloudProp("cloud.application.host", hostname, cloudProps);
        this.addCloudProp("cloud.application.port", primaryPort, cloudProps);
        this.addCloudProp("cloud.application.secondary-port", secondaryPort, cloudProps);
        this.addCloudProp("cloud.application.tertiary-port", tertiaryPort, cloudProps);
    }

    private void configureSlot(ApplicationProperties props, Map<String, Object> cloudProps) {
        ApplicationConfig cfg = props.cfg();
        String slot = null;
        if (cfg.containsKey("cloud.application.instance_index") && RANDOM.equalsIgnoreCase(slot = cfg.getString("cloud.application.instance_index"))) {
            slot = RandomStringUtils.randomAlphanumeric((int)this.getClass().getSimpleName().length());
        }
        if (StringUtils.isNotEmpty((CharSequence)System.getenv(INDEX))) {
            slot = System.getenv(INDEX);
        }
        if (StringUtils.isEmpty((CharSequence)slot)) {
            slot = String.valueOf(0);
        }
        this.addCloudProp("cloud.application.instance_index", slot, cloudProps);
    }

    private void configureSiteName(ApplicationProperties props, Map<String, Object> cloudProps) {
        ApplicationConfig cfg = props.cfg();
        this.spaceName = System.getenv(ENV_SPACE_NAME);
        if (cfg.containsKey("cloud.application.space_name")) {
            this.spaceName = cfg.getString("cloud.application.space_name");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.spaceName)) {
            this.addCloudProp("cloud.application.space_name", this.spaceName, cloudProps);
        }
    }

    private void configureInstance(ApplicationProperties props) {
        ApplicationConfig cfg = props.cfg();
        if (cfg.containsKey("cloud.application.app-id")) {
            this.appId = cfg.getString("cloud.application.app-id");
        }
        this.instanceId = UUID.randomUUID().toString();
    }

    private void configureAppName(ApplicationProperties props, Map<String, Object> cloudProps) {
        ApplicationConfig cfg = props.cfg();
        if (cfg.containsKey("cloud.application.name")) {
            String appName = cfg.getString("cloud.application.name");
            this.addCloudProp("cloud.application.name", appName, cloudProps);
        }
    }

    private void configureServices(ApplicationProperties props, KeyStore keyStore, Map<String, ServiceInfo> map) throws Exception {
        ApplicationConfig cfg = props.cfg();
        Config prefixedView = cfg.getPrefixedView("service");
        Iterator it = prefixedView.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            int idx = key.indexOf(".uri");
            if (idx <= 0) continue;
            String serviceId = key.substring(0, idx);
            String value = prefixedView.getRawProperty(key).toString();
            RawServiceInfo raw = new RawServiceInfo(serviceId, value.getBytes(StandardCharsets.UTF_8));
            map.put(serviceId, raw);
            try {
                URI serviceUri = new URI(value);
                if (!StringUtils.isNotEmpty((CharSequence)serviceUri.getScheme())) continue;
                ServiceInfo serviceInfo = ConfigurableCloudConnector.toServiceInfo(serviceId, serviceUri);
                map.put(serviceId, serviceInfo);
            }
            catch (URISyntaxException serviceUri) {}
        }
        LinkedList cacerts = Lists.newLinkedList();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (entry.getKey().startsWith(ENV_CACERT_PREFIX)) {
                File pem = new File(entry.getValue());
                byte[] bytes = Files.readAllBytes(pem.toPath());
                String raw = new String(bytes, StandardCharsets.UTF_8);
                StringReader reader = new StringReader(raw);
                try {
                    PEMParser parser = new PEMParser((Reader)reader);
                    try {
                        X509CertificateHolder keyInfo = (X509CertificateHolder)parser.readObject();
                        ByteArrayInputStream io = new ByteArrayInputStream(keyInfo.getEncoded());
                        try {
                            CertificateFactory fact = CertificateFactory.getInstance("X.509");
                            X509Certificate cer = (X509Certificate)fact.generateCertificate(io);
                            cacerts.add(cer);
                            continue;
                        }
                        finally {
                            io.close();
                            continue;
                        }
                    }
                    finally {
                        parser.close();
                        continue;
                    }
                }
                finally {
                    reader.close();
                    continue;
                }
            }
            if (!entry.getKey().startsWith(ENV_UPS_PREFIX)) continue;
            String key = entry.getKey();
            String value = entry.getValue();
            String serviceId = key.substring(ENV_UPS_PREFIX.length()).trim().toLowerCase();
            if (key.endsWith(FILE_SUFFIX)) {
                File f = new File(value);
                byte[] encoded = Files.readAllBytes(f.toPath());
                value = new String(encoded, StandardCharsets.UTF_8);
                serviceId = serviceId.substring(0, serviceId.length() - FILE_SUFFIX.length());
                this.logger.debug("secret={} has been loaded from={} ...", (Object)serviceId, (Object)f);
            }
            RawServiceInfo raw = new RawServiceInfo(serviceId, value.getBytes(StandardCharsets.UTF_8));
            map.put(serviceId, raw);
            try {
                URI serviceUri = new URI(value);
                if (!StringUtils.isNotEmpty((CharSequence)serviceUri.getScheme())) continue;
                ServiceInfo serviceInfo = ConfigurableCloudConnector.toServiceInfo(serviceId, serviceUri);
                map.put(serviceId, serviceInfo);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (!cacerts.isEmpty()) {
            SSL.addCertificates(keyStore, cacerts);
        }
    }

    private static ServiceInfo toServiceInfo(String id, URI uri) {
        String protocol;
        String scheme = uri.getScheme();
        String[] details = scheme.split("\\+");
        switch (protocol = details[details.length - 1]) {
            case "oracle": {
                return new OracleServiceInfo(id, uri.toString());
            }
            case "postgres": {
                return new PostgresqlServiceInfo(id, uri.toString());
            }
            case "mysql": {
                return new MysqlServiceInfo(id, uri.toString());
            }
            case "mariadb": {
                return new MariaDBServiceInfo(id, uri.toString());
            }
            case "hsqldb": {
                return new HsqlServiceInfo(id, uri.toString());
            }
            case "h2": {
                return new H2ServiceInfo(id, uri.toString());
            }
            case "redis": 
            case "rediss": {
                return new RedisServiceInfo(id, uri.toString());
            }
            case "kafka": {
                return new PlainServiceInfo(id, uri.toString());
            }
            case "http": 
            case "https": 
            case "tcp": 
            case "file": {
                return new PlainServiceInfo(id, uri.toString());
            }
        }
        throw new IllegalArgumentException("unknown schema: " + protocol);
    }

    private void addCloudProp(String key, Object value, Map<String, Object> props) {
        this.logger.debug("adding {}={}", (Object)key, value);
        props.put(key, Objects.requireNonNull(value));
    }
}

