/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.turbospaces.boot.AbstractHealtchCheck;
import com.turbospaces.cfg.ApplicationProperties;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class HttpHealthCheck
extends AbstractHealtchCheck {
    private static final int OK = 200;
    private final boolean bootstrapOnly;
    private final Set<Integer> okCodes;
    private final ApplicationProperties props;
    private final URI uri;

    public HttpHealthCheck(ApplicationProperties props, URI uri) {
        this(props, uri, false);
    }

    public HttpHealthCheck(ApplicationProperties props, URI uri, boolean bootstrapOnly) {
        this(props, uri, Collections.singleton(200), bootstrapOnly);
    }

    public HttpHealthCheck(ApplicationProperties props, URI uri, Collection<Integer> okCodes, boolean bootstrapOnly) {
        if (okCodes.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.props = Objects.requireNonNull(props);
        this.uri = Objects.requireNonNull(uri);
        this.okCodes = new HashSet<Integer>(okCodes);
        this.bootstrapOnly = bootstrapOnly;
    }

    protected HealthCheck.Result check() throws Exception {
        try {
            this.logger.debug("checking connectivity {} ...", (Object)this.uri);
            HttpURLConnection conn = (HttpURLConnection)this.uri.toURL().openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(((Integer)this.props.TCP_CONNECTION_TIMEOUT.get()).intValue()));
            conn.setReadTimeout((int)TimeUnit.SECONDS.toMillis(((Integer)this.props.TCP_SOCKET_TIMEOUT.get()).intValue()));
            String userInfo = this.uri.getUserInfo();
            if (userInfo != null && !userInfo.isEmpty()) {
                String auth = Base64.getEncoder().encodeToString(userInfo.getBytes());
                conn.setRequestProperty("Authorization", "Basic " + auth);
            }
            boolean okCode = this.okCodes.contains(conn.getResponseCode());
            StringBuilder sb = new StringBuilder();
            if (okCode) {
                try (InputStream io = conn.getInputStream();
                     BufferedReader br = new BufferedReader(new InputStreamReader(io));){
                    String output;
                    while ((output = br.readLine()) != null) {
                        sb.append(output);
                    }
                }
            }
            this.logger.debug("{} response: {}", (Object)this.uri, (Object)conn.getResponseCode());
            return okCode ? HealthCheck.Result.healthy((String)sb.toString()) : HealthCheck.Result.unhealthy((String)("unexpected response code: " + conn.getResponseCode()));
        }
        catch (Exception err) {
            this.logger.warn(err.getMessage(), (Throwable)err);
            return HealthCheck.Result.unhealthy((Throwable)err);
        }
    }

    public void destroy() throws Exception {
    }

    @Override
    public boolean isBootstrapOnly() {
        return this.bootstrapOnly;
    }
}

