/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common.logging;

import com.turbospaces.common.logging.MaskObfuscator;
import com.turbospaces.common.logging.Obfuscators;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class MaskObfuscatorTest {
    MaskObfuscatorTest() {
    }

    public static Stream<Arguments> testObfuscateJsonData() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{"", ""}), Arguments.of((Object[])new Object[]{"{}", "{}"}), Arguments.of((Object[])new Object[]{"{\"address\":\"***\"}", "{\"address\":\"foo\"}"}), Arguments.of((Object[])new Object[]{"{\n    \"user_id\":\"87656\",\n    \"address\" : \"************************\",\n    \"city\":\"Chicago\"\n }", "{\n    \"user_id\":\"87656\",\n    \"address\" : \"hotel California, ap. 42\",\n    \"city\":\"Chicago\"\n }"}), Arguments.of((Object[])new Object[]{"{\"password\":\"*****\",\"address\":\"************************\"}", "{\"password\":\"87656\",\"address\":\"hotel California, ap. 42\"}"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testObfuscateJsonData"})
    void testObfuscateJson(String expected, String msg) {
        MaskObfuscator jsonObfuscator = new MaskObfuscator(Arrays.asList(Obfuscators.jsonStrFieldMaskPattern((String)"address"), Obfuscators.jsonStrFieldMaskPattern((String)"password")));
        Assertions.assertEquals((Object)expected, (Object)jsonObfuscator.obfuscate(msg));
    }

    public static Stream<Arguments> testObfuscateQueryData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"", ""}), Arguments.of((Object[])new Object[]{"{}", "{}"}), Arguments.of((Object[])new Object[]{"https://skrill.com/app/pay.pl?password=***", "https://skrill.com/app/pay.pl?password=foo"}), Arguments.of((Object[])new Object[]{"prepare req: GET https://skrill.com/app/pay.pl?action=prepare&email=paysafe%40ysi-group.com&password=********************************&amount=150.00&currency=***&transaction_id=3d8224a1 HTTP/1.1", "prepare req: GET https://skrill.com/app/pay.pl?action=prepare&email=paysafe%40ysi-group.com&password=1acbf769dbd19ee3030199817d1f8966&amount=150.00&currency=USD&transaction_id=3d8224a1 HTTP/1.1"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testObfuscateQueryData"})
    void testObfuscateQuery(String expected, String msg) {
        MaskObfuscator queryObfuscator = new MaskObfuscator(Arrays.asList(Obfuscators.queryParamMaskPattern((String)"password"), Obfuscators.queryParamMaskPattern((String)"currency")));
        Assertions.assertEquals((Object)expected, (Object)queryObfuscator.obfuscate(msg));
    }
}

