package com.turbospaces.boot;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.stream.Stream;

import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.ThrowableAction;

import io.micrometer.core.instrument.simple.SimpleMeterRegistry;

public class PlatformTest {
    @Test
    public void takeUntil() {
        List<String> list = Arrays.asList( "1", "2", "3" );
        Stream<String> stream = list.stream();
        MutableInt count = new MutableInt();
        PlatformUtil.takeWhile( stream, new Predicate<String>() {
            @Override
            public boolean test(String t) {
                count.increment();
                return count.intValue() < 2;
            }
        } ).count();
        Assertions.assertEquals( 2, count.intValue() );
    }
    @Test
    public void works() throws Exception {
        Logger logger = LoggerFactory.getLogger( getClass() );
        ApplicationConfig cfg = ApplicationConfig.create();
        cfg.setLocalProperty( ApplicationProperties.APP_PLATFORM_GRACEFUL_TIMEOUT_KEY, 1 );

        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        Platform platform = new FixedSizePlatform( new ApplicationProperties( cfg ), registry );
        CountDownLatch semaphore = new CountDownLatch( 1 );
        CountDownLatch l = new CountDownLatch( 1 );
        CountDownLatch interrupted = new CountDownLatch( 1 );
        platform.work( new ThrowableAction() {
            @Override
            public void apply() throws Exception {
                semaphore.await();
                l.countDown();
            }
        } );
        platform.execute( new Runnable() {
            @Override
            public void run() {
                semaphore.countDown();
            }
        } );
        l.await();
        CountDownLatch started = new CountDownLatch( 1 );
        platform.work( new ThrowableAction() {
            @Override
            public void apply() {
                synchronized ( this ) {
                    try {
                        logger.debug( "about to hang forever ..." );
                        Thread.sleep( 1000 );
                        logger.debug( "count down to mark started ..." );
                        started.countDown();
                        wait();
                    }
                    catch ( InterruptedException err ) {
                        interrupted.countDown();
                    }
                }
            }
        } );
        started.await();
        platform.dispose();
        interrupted.await();
    }
}
