/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.turbospaces.boot.AbstractHealtchCheck;
import com.turbospaces.cfg.ApplicationProperties;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.service.UriBasedServiceInfo;

public class SocketHealthCheck
extends AbstractHealtchCheck {
    private final boolean bootstrapOnly;
    private final ApplicationProperties props;
    private final UriBasedServiceInfo serviceInfo;

    public SocketHealthCheck(ApplicationProperties props, UriBasedServiceInfo serviceInfo) {
        this(props, serviceInfo, false);
    }

    public SocketHealthCheck(ApplicationProperties props, UriBasedServiceInfo serviceInfo, boolean bootstrapOnly) {
        this.props = Objects.requireNonNull(props);
        this.serviceInfo = Objects.requireNonNull(serviceInfo);
        this.bootstrapOnly = bootstrapOnly;
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result result;
        String host = this.serviceInfo.getHost();
        int port = this.serviceInfo.getPort();
        if (port <= 0) {
            switch (this.serviceInfo.getScheme()) {
                case "http": 
                case "https": {
                    URL url = new URI(this.serviceInfo.getUri()).toURL();
                    port = url.getDefaultPort();
                    break;
                }
            }
        }
        this.logger.debug("checking TCP connection on {}:{} ...", (Object)host, (Object)port);
        Socket socket = new Socket();
        try {
            InetSocketAddress addr = new InetSocketAddress(host, port);
            socket.setTcpNoDelay((Boolean)this.props.TCP_NODELAY.get());
            socket.setKeepAlive((Boolean)this.props.TCP_KEEP_ALIVE.get());
            socket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(((Integer)this.props.TCP_SOCKET_TIMEOUT.get()).intValue()));
            socket.connect(addr, (int)TimeUnit.SECONDS.toMillis(((Integer)this.props.TCP_CONNECTION_TIMEOUT.get()).intValue()));
            result = HealthCheck.Result.healthy((String)("connected to: " + addr.toString()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception err) {
                this.logger.warn(err.getMessage(), (Throwable)err);
                return HealthCheck.Result.unhealthy((String)err.getMessage());
            }
        }
        socket.close();
        return result;
    }

    @Override
    public boolean isBootstrapOnly() {
        return this.bootstrapOnly;
    }

    public void destroy() throws Exception {
    }
}

