package com.turbospaces.boot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.executor.Executors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;

import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

public class ConfigurablePlatform extends AbstractExecutionPlatform {
    private final ExecutorService executor;

    public ConfigurablePlatform(String name, ApplicationProperties props, MeterRegistry meter) {
        super(props);

        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(false);
        tfb.setNameFormat(name + "-%d");
        ThreadFactory threadFactory = tfb.build();

        int minPoolSize = props.cfg().getInteger(name + ".min.pool.size", 4);
        int maxPoolSize = props.cfg().getInteger(name + ".max.pool.size", props.APP_PLATFORM_POOL_SIZE.get());
        ExecutorService pool = Executors.newScalingThreadPool(minPoolSize, maxPoolSize, props.APP_PLATFORM_POOL_THREAD_TTL.get(), threadFactory);

        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics(pool, name, Collections.emptyList());
        metrics.bindTo(meter);

        executor = pool;
    }

    @Override
    public ExecutorService executor() {
        return executor;
    }
}
