/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.boot.AbstractExecutionPlatform;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.executor.Executors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ConfigurablePlatform
extends AbstractExecutionPlatform {
    private final String name;
    private final ExecutorService executor;
    private final ConcurrentInitializer<Scheduler> scheduler = new LazyInitializer<Scheduler>(){

        protected Scheduler initialize() {
            return Schedulers.fromExecutorService((ExecutorService)ConfigurablePlatform.this.executor, (String)ConfigurablePlatform.this.name);
        }
    };

    public ConfigurablePlatform(String name, ApplicationProperties props, MeterRegistry meter) {
        super(props);
        this.name = Objects.requireNonNull(name);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(false);
        tfb.setNameFormat(name + "-%d");
        ThreadFactory threadFactory = tfb.build();
        int minPoolSize = props.cfg().getInteger(name + ".min.pool.size", 4);
        int maxPoolSize = props.cfg().getInteger(name + ".max.pool.size", (Integer)props.APP_PLATFORM_POOL_SIZE.get());
        ExecutorService pool = Executors.newScalingThreadPool(minPoolSize, maxPoolSize, (Duration)props.APP_PLATFORM_POOL_THREAD_TTL.get(), threadFactory);
        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics(pool, name, Collections.emptyList());
        metrics.bindTo(meter);
        this.executor = pool;
    }

    @Override
    public Scheduler scheduler() {
        try {
            return (Scheduler)this.scheduler.get();
        }
        catch (ConcurrentException e) {
            this.logger.error("Error when initializing scheduler", (Throwable)e);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public ExecutorService executor() {
        return this.executor;
    }
}

