package com.turbospaces.boot;

import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.ThrowableAction;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CountDownLatch;

public class ConfigurablePlatformTest {
    @Test
    public void worksConfigurablePlatform() throws Exception {
        Logger logger = LoggerFactory.getLogger( getClass() );
        ApplicationConfig cfg = ApplicationConfig.create();
        cfg.setLocalProperty( ApplicationProperties.APP_PLATFORM_GRACEFUL_TIMEOUT_KEY, 1 );
        cfg.setLocalProperty( "test.max.pool.size", 2 );
        cfg.setLocalProperty( "test.min.pool.size", 1 );

        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        ExecutionPlatform platform = new ConfigurablePlatform("test", new ApplicationProperties( cfg ), registry );
        CountDownLatch semaphore = new CountDownLatch( 1 );
        CountDownLatch l = new CountDownLatch( 1 );
        CountDownLatch interrupted = new CountDownLatch( 1 );
        platform.work( new ThrowableAction() {
            @Override
            public void apply() throws Exception {
                System.out.println("work");
                semaphore.await();
                l.countDown();
            }
        } );
        platform.execute( new Runnable() {
            @Override
            public void run() {
                System.out.println("execute");
                semaphore.countDown();
            }
        } );
        l.await();
        CountDownLatch started = new CountDownLatch( 1 );
        platform.work( new ThrowableAction() {
            @Override
            public void apply() {
                synchronized ( this ) {
                    try {
                        logger.debug( "about to hang forever ..." );
                        Thread.sleep( 1000 );
                        logger.debug( "count down to mark started ..." );
                        started.countDown();
                        wait();
                    }
                    catch ( InterruptedException err ) {
                        interrupted.countDown();
                    }
                }
            }
        } );
        started.await();
        platform.dispose();
        interrupted.await();
        Assertions.assertEquals(platform.scheduler(), platform.scheduler());
    }
}
