/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common.logging;

import com.turbospaces.common.logging.Obfuscator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class MaskObfuscator
implements Obfuscator<String> {
    private final Pattern pattern;

    public MaskObfuscator(List<String> patterns) {
        this.pattern = Pattern.compile(String.join((CharSequence)"|", patterns), 8);
    }

    @Override
    public String obfuscate(String message) {
        if (message == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder(message);
            Matcher matcher = this.pattern.matcher(sb);
            while (matcher.find()) {
                IntStream.rangeClosed(1, matcher.groupCount()).forEach(group -> {
                    if (matcher.group(group) != null) {
                        IntStream.range(matcher.start(group), matcher.end(group)).forEach(i -> sb.setCharAt(i, '*'));
                    }
                });
            }
            return sb.toString();
        }
        catch (Exception e) {
            return message;
        }
    }
}

