/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.config.PollingStrategy;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EmptyConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.config.polling.FixedPollingStrategy;
import com.turbospaces.cfg.CloudOptions;
import com.turbospaces.cfg.DynamicCompositeConfig;
import com.turbospaces.cfg.DynamicPropertyFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import reactor.core.Disposable;

public class ApplicationConfig
extends DefaultCompositeConfig
implements DynamicCompositeConfig,
CloudOptions,
PollingStrategy,
Disposable {
    private final Logger logger = LoggerFactory.getLogger(ApplicationConfig.class);
    private final PollingStrategy pollingStrategy;
    private final DynamicPropertyFactory propertyFactory;

    public ApplicationConfig() throws ConfigException {
        LinkedList<String> ignorePattern = new LinkedList<String>();
        ignorePattern.add("UPS_");
        ignorePattern.add("SPACE_NAME");
        ignorePattern.add("HOSTNAME");
        HashMap<String, String> oldgetenv = new HashMap<String, String>(System.getenv());
        HashMap<String, String> newgetenv = new HashMap<String, String>();
        for (Map.Entry it : oldgetenv.entrySet()) {
            String oldProp = (String)it.getKey();
            String newProp = oldProp.toLowerCase().replaceAll("_", ".");
            boolean allowed = true;
            for (String s : ignorePattern) {
                if (!oldProp.startsWith(s)) continue;
                allowed = false;
                break;
            }
            if (!allowed) continue;
            this.logger.trace("adding ENV prop {}={}", new Object[]{oldProp, newProp, it.getValue()});
            newgetenv.put(newProp, (String)it.getValue());
        }
        this.addConfig("core.RUNTIME_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.LOCAL_APPLICATION_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.CLOUD_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.CMD_LINE_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.ENV_PROPS_CFG", (com.netflix.archaius.api.Config)new MapConfig(newgetenv));
        this.addConfig("core.SYSTEM_PROPS_CFG", (com.netflix.archaius.api.Config)new SystemConfig());
        this.addConfig("core.GIT_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.LEGACY_CFG", (com.netflix.archaius.api.Config)EmptyConfig.INSTANCE);
        this.addConfig("core.DEFAULT_APP_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addBuildMetaConfig(new DefaultSettableConfig());
        this.propertyFactory = DynamicPropertyFactory.from((com.netflix.archaius.api.Config)this);
        long freq = this.getLong("app.timer.interval", 30L);
        this.pollingStrategy = new FixedPollingStrategy(freq, TimeUnit.SECONDS);
    }

    private void addBuildMetaConfig(DefaultSettableConfig cfg) throws ConfigException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("git.properties");){
            if (is != null) {
                this.addConfig("core.BUILD_META_CFG", (com.netflix.archaius.api.Config)cfg);
                Properties props = new Properties();
                props.load(is);
                cfg.setProperties(props);
            }
        }
        catch (IOException e) {
            this.logger.error("Can't load git build properties", (Throwable)e);
        }
    }

    public void dispose() {
        this.shutdown();
    }

    public Future<?> execute(Runnable run) {
        return this.pollingStrategy.execute(run);
    }

    public void shutdown() {
        this.pollingStrategy.shutdown();
    }

    @Override
    public DynamicPropertyFactory factory() {
        return this.propertyFactory;
    }

    @Override
    public List<String> getStringList(Property<String> prop) {
        LinkedList<String> l = new LinkedList<String>();
        if (this.containsKey(prop.getKey())) {
            Object raw = this.getRawProperty(prop.getKey());
            if (raw instanceof String) {
                l.addAll(this.getList(prop.getKey(), String.class));
            } else {
                l.addAll((Collection)raw);
            }
        } else {
            String value = (String)prop.get();
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                String[] split;
                for (String s : split = value.split(this.getListDelimiter())) {
                    l.add(s);
                }
            }
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(l, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return StringUtils.isNotEmpty((CharSequence)input);
            }
        }));
    }

    @Override
    public List<Integer> getIntList(Property<Integer> prop) {
        LinkedList<Integer> l = new LinkedList<Integer>();
        if (this.containsKey(prop.getKey())) {
            Object raw = this.getRawProperty(prop.getKey());
            if (raw instanceof String) {
                l.addAll(this.getList(prop.getKey(), Integer.class));
            } else {
                l.addAll((Collection)raw);
            }
        } else {
            l.add((Integer)prop.get());
        }
        return l;
    }

    @Override
    public List<Long> getLongList(Property<Long> prop) {
        LinkedList<Long> l = new LinkedList<Long>();
        if (this.containsKey(prop.getKey())) {
            Object raw = this.getRawProperty(prop.getKey());
            if (raw instanceof String) {
                l.addAll(this.getList(prop.getKey(), Long.class));
            } else {
                l.addAll((Collection)raw);
            }
        } else {
            l.add((Long)prop.get());
        }
        return l;
    }

    @Override
    public void clearLocalProperty(String key) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.LOCAL_APPLICATION_CFG");
        c.clearProperty(key);
        this.logger.info("clearing local prop: {}", (Object)key);
    }

    @Override
    public void setLocalProperty(String key, Object value) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.LOCAL_APPLICATION_CFG");
        c.setProperty(key, value);
        this.logger.info("setting local prop: {} -> {}", (Object)key, value);
    }

    @Override
    public void setLocalProperties(Properties props) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.LOCAL_APPLICATION_CFG");
        c.setProperties(props);
        this.logger.info("setting local props: {}", (Object)props);
    }

    @Override
    public void clearGitProperty(String key) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.GIT_CFG");
        c.clearProperty(key);
        this.logger.info("clearing git prop: {}", (Object)key);
    }

    @Override
    public void setGitProperty(String key, Object value) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.GIT_CFG");
        c.setProperty(key, value);
        this.logger.info("setting git prop: {} -> {}", (Object)key, value);
    }

    @Override
    public void setGitProperties(Properties props) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.GIT_CFG");
        c.setProperties(props);
        this.logger.info("setting git props: {}", (Object)props);
    }

    @Override
    public void clearCmdLineParams(String key) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.CMD_LINE_CFG");
        c.clearProperty(key);
        this.logger.info("clearing command line prop: {}", (Object)key);
    }

    @Override
    public void setCmdLineParams(String key, Object value) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.CMD_LINE_CFG");
        c.setProperty(key, value);
        this.logger.info("setting command line prop: {} -> {}", (Object)key, value);
    }

    @Override
    public void setCmdLineParams(Properties props) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.CMD_LINE_CFG");
        c.setProperties(props);
        this.logger.info("setting command line props: {}", (Object)props);
    }

    @Override
    public void clearDefaultProperty(String key) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.DEFAULT_APP_CFG");
        c.clearProperty(key);
        this.logger.info("clearing default prop: {}", (Object)key);
    }

    @Override
    public void setDefaultProperty(String key, Object value) {
        SettableConfig c = (SettableConfig)this.getConfig("core.DEFAULT_APP_CFG");
        c.setProperty(key, value);
        this.logger.info("setting default prop: {} -> {}", (Object)key, value);
    }

    @Override
    public void setDefaultProperties(Properties props) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.DEFAULT_APP_CFG");
        c.setProperties(props);
        this.logger.info("setting default props: {}", (Object)props);
    }

    @Override
    public void clearAllDefaultProperties() throws ConfigException {
        this.replaceConfig("core.DEFAULT_APP_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
    }

    @Override
    public ApplicationConfig loadLocalDevProperties(String username) throws Exception {
        String userOverrideProps = String.format("classpath:local-dev-%s.properties", username);
        String userOverrideCfg = String.format("classpath:local-dev-%s.conf", username);
        URL propsURL = null;
        URL cfgURL = null;
        try {
            propsURL = ResourceUtils.getURL((String)userOverrideProps);
        }
        catch (FileNotFoundException err) {
            try {
                userOverrideProps = "classpath:local-dev-template.properties";
                this.logger.debug("no user specific props file found, will try to lookup = '{}'", (Object)userOverrideProps);
                propsURL = ResourceUtils.getURL((String)userOverrideProps);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        try {
            cfgURL = ResourceUtils.getURL((String)userOverrideCfg);
        }
        catch (FileNotFoundException err) {
            try {
                userOverrideCfg = "classpath:local-dev-template.conf";
                this.logger.debug("no user specific cfg file found, attempting to lookup = '{}'", (Object)userOverrideCfg);
                cfgURL = ResourceUtils.getURL((String)userOverrideCfg);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (propsURL != null) {
            try (InputStream io = propsURL.openStream();){
                Properties tmp = new Properties();
                tmp.load(io);
                this.setLocalProperties(tmp);
            }
        }
        if (cfgURL != null) {
            File file = new File(cfgURL.toURI());
            ConfigParseOptions parseOptions = ConfigParseOptions.defaults().setAllowMissing(false).setSyntax(ConfigSyntax.CONF);
            Config typesafeConfig = ConfigFactory.parseFile((File)file, (ConfigParseOptions)parseOptions).resolve();
            for (Map.Entry entry : typesafeConfig.entrySet()) {
                String key = (String)entry.getKey();
                Object value = ((ConfigValue)entry.getValue()).unwrapped();
                this.setLocalProperty(key, value);
            }
        }
        return this;
    }

    @Override
    public ApplicationConfig loadDefaultPropsFromResource(URL resource) throws IOException {
        try (InputStream io = resource.openStream();){
            Properties props = new Properties();
            props.load(io);
            this.setDefaultProperties(props);
        }
        return this;
    }

    @Override
    public ApplicationConfig loadLocalDevProperties() throws Exception {
        String username = System.getProperty("user.name");
        this.loadLocalDevProperties(username);
        return this;
    }

    public static ApplicationConfig create() throws ConfigException {
        return new ApplicationConfig();
    }

    public static ApplicationConfig create(String appId) throws ConfigException {
        ApplicationConfig cfg = ApplicationConfig.create();
        cfg.setDefaultProperty("cloud.application.app-id", appId);
        return cfg;
    }
}

