/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.turbospaces.common.RequestReplyFuture;
import com.turbospaces.common.RequestReplyMapper;
import com.turbospaces.common.RequestReplyTimeout;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class CompletableRequestReplyMapper<K, V>
implements RequestReplyMapper<K, V>,
InitializingBean,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<K, RequestReplyFuture<V>> corr = new ConcurrentHashMap<K, RequestReplyFuture<V>>();
    private final ThreadPoolTaskScheduler timer = new ThreadPoolTaskScheduler();

    public CompletableRequestReplyMapper() {
        this.timer.setDaemon(true);
        this.timer.setRemoveOnCancelPolicy(true);
        this.timer.setPoolSize(Runtime.getRuntime().availableProcessors());
    }

    public void afterPropertiesSet() {
        this.timer.afterPropertiesSet();
    }

    public void destroy() {
        this.timer.destroy();
    }

    @Override
    public RequestReplyFuture<V> acquire(final K key, final int timeout, final TimeUnit unit) {
        boolean duplicate;
        final Map mdc = MDC.getCopyOfContextMap();
        ScheduledFuture timeoutTask = this.timer.schedule(new Runnable(){

            @Override
            public void run() {
                RequestReplyFuture tmp = (RequestReplyFuture)CompletableRequestReplyMapper.this.corr.remove(key);
                if (tmp != null && !tmp.isDone()) {
                    if (mdc != null) {
                        MDC.setContextMap((Map)mdc);
                    }
                    try {
                        RequestReplyTimeout timeoutException = new RequestReplyTimeout(timeout, unit, key);
                        tmp.completeExceptionally(timeoutException);
                        CompletableRequestReplyMapper.this.logger.debug("request-reply(m={}) removing subj due to timeout", key);
                    }
                    catch (Exception err) {
                        CompletableRequestReplyMapper.this.logger.error(err.getMessage(), (Throwable)err);
                    }
                    finally {
                        MDC.clear();
                    }
                }
            }
        }, Instant.now().plusSeconds(timeout));
        RequestReplyFuture toReturn = new RequestReplyFuture(key, timeoutTask);
        final long now = System.currentTimeMillis();
        toReturn.whenComplete(new BiConsumer<V, Throwable>(){

            @Override
            public void accept(V resp, Throwable err) {
                if (err == null) {
                    CompletableRequestReplyMapper.this.logger.debug("request-reply(m={}) completed in {} 'ms'", key, (Object)(System.currentTimeMillis() - now));
                }
            }
        });
        boolean bl = duplicate = this.corr.putIfAbsent(key, toReturn) != null;
        if (duplicate) {
            timeoutTask.cancel(true);
            throw new RuntimeException("duplicate key violation corrId: " + key);
        }
        return toReturn;
    }

    @Override
    public void complete(K key, V value) {
        CompletableFuture subj = (CompletableFuture)this.corr.remove(Objects.requireNonNull(key));
        if (subj != null) {
            subj.complete(value);
        } else {
            this.logger.trace("no such correlation for key: {}", key);
        }
    }

    @Override
    public void completeExceptionally(K key, Throwable reason) {
        CompletableFuture subj = (CompletableFuture)this.corr.remove(Objects.requireNonNull(key));
        if (subj != null) {
            subj.completeExceptionally(reason);
        }
    }

    @Override
    public void completeExceptionally(Throwable reason) {
        for (CompletableFuture f : this.corr.values()) {
            f.completeExceptionally(reason);
        }
    }

    @Override
    public void clear() {
        this.corr.clear();
    }

    @Override
    public int pendingCount() {
        return this.corr.size();
    }
}

