/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckFilter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.ThreadDump;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Uninterruptibles;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.config.DefaultConfigListener;
import com.netflix.archaius.config.PollingDynamicConfig;
import com.turbospaces.boot.AbstractHealtchCheck;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.boot.Channel;
import com.turbospaces.boot.FixedSizePlatform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.logging.Obfuscators;
import com.turbospaces.logging.AlertLoggingFilter;
import com.turbospaces.logging.Logback;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.UPSs;
import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.ElasticMeterRegistry;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;
import io.opentracing.Tracer;
import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.connection.EventSendCallback;
import io.sentry.event.Event;
import io.sentry.event.helper.ShouldSendEventCallback;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.ConfigurableCloudConnector;
import org.springframework.cloud.ConfigurableCloudFactory;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ResourceUtils;

public abstract class AbstractBootstrap<PROPS extends ApplicationProperties>
extends SpringApplication
implements Bootstrap,
ShouldSendEventCallback {
    private final org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final CompositeMeterRegistry meterRegistry = Metrics.globalRegistry;
    private final List<MeterBinder> binders = Lists.newLinkedList();
    private final Set<Channel> channels = new LinkedHashSet<Channel>();
    private final JmxReporter jmxReporter;
    private final ConsoleReporter consoleReporter;
    private final HealthCheckRegistry healthCheckRegistry;
    private final Thread shutdownHook;
    private final String release;
    private final Cloud cloud;
    private final PROPS props;
    private final AbstractEnvironment env;
    private ConfigurableApplicationContext applicationContext;
    private final FixedSizePlatform platform;
    private final SentryClient sentry;
    private final JaegerTracer tracer;
    private KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());

    protected AbstractBootstrap(Class<?> mainClass, PROPS props) throws Exception {
        super(new Class[]{mainClass});
        String[] infoByDefault;
        this.props = (ApplicationProperties)Objects.requireNonNull(props);
        this.env = new AbstractEnvironment((ApplicationProperties)props){
            final /* synthetic */ ApplicationProperties val$props;
            {
                this.val$props = applicationProperties;
            }

            protected void customizePropertySources(MutablePropertySources sources) {
                sources.addFirst((PropertySource)new PropertySource<Object>("archaius"){

                    public Object getProperty(String key) {
                        return val$props.cfg().getRawProperty(key);
                    }
                });
            }

            protected ConfigurablePropertyResolver createPropertyResolver(MutablePropertySources sources) {
                return ConfigurationPropertySources.createPropertyResolver((MutablePropertySources)sources);
            }
        };
        this.setWebApplicationType(WebApplicationType.NONE);
        this.setLogStartupInfo(false);
        this.setEnvironment((ConfigurableEnvironment)this.env);
        this.setRegisterShutdownHook(false);
        ConfigurableCloudConnector connector = new ConfigurableCloudConnector((ApplicationProperties)props, this.keyStore);
        ApplicationInstanceInfo info = connector.getApplicationInstanceInfo();
        Map cloudProps = info.getProperties();
        String space = cloudProps.get("cloud.application.space_name").toString();
        String host = cloudProps.get("cloud.application.host").toString();
        String slot = cloudProps.get("cloud.application.instance_index").toString();
        String service = info.getAppId();
        this.release = PlatformUtil.version(((ApplicationProperties)props).CLOUD_APP_NAME);
        Optional sentryOpt = UPSs.findServiceInfoByName(connector, "sentry");
        if (sentryOpt.isPresent()) {
            UriBasedServiceInfo serviceInfo = (UriBasedServiceInfo)sentryOpt.get();
            this.sentry = SentryClientFactory.sentryClient((String)serviceInfo.getUri());
        } else {
            this.sentry = SentryClientFactory.sentryClient();
        }
        this.sentry.setEnvironment(space);
        this.sentry.setRelease(this.release);
        this.sentry.setServerName(service + "/" + slot);
        this.sentry.addShouldSendEventCallback((ShouldSendEventCallback)this);
        this.sentry.addEventSendCallback(new EventSendCallback(){

            public void onSuccess(Event event) {
                Counter counter = AbstractBootstrap.this.metricRegistry.counter(MetricRegistry.name((String)"sentry", (String[])new String[]{"success"}));
                counter.inc();
            }

            public void onFailure(Event event, Exception exception) {
                Counter counter = AbstractBootstrap.this.metricRegistry.counter(MetricRegistry.name((String)"sentry", (String[])new String[]{"failure"}));
                counter.inc();
            }
        });
        LoggerContext loggerFactory = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerFactory.setPackagingDataEnabled(this.isDevMode());
        for (String it : infoByDefault = new String[]{"org.eclipse.jgit"}) {
            Logger log = loggerFactory.getLogger(it);
            log.setLevel(Level.INFO);
        }
        MutableObject logFile = new MutableObject();
        ConfigurableCloudFactory cloudFactory = new ConfigurableCloudFactory(connector, this, (MutableObject<URL>)logFile);
        this.cloud = cloudFactory.getCloud();
        this.configureLogging((MutableObject<URL>)logFile);
        ImmutableMap.Builder tracingTags = ImmutableMap.builder();
        tracingTags.put((Object)"ip", (Object)PlatformUtil.detectIp());
        tracingTags.put((Object)"hostname", (Object)host);
        tracingTags.put((Object)"cloud.application.instance_index", (Object)slot);
        Configuration fromEnv = Configuration.fromEnv((String)service).withTracerTags((Map)tracingTags.build());
        this.tracer = fromEnv.getTracer();
        ImmutableList.Builder meterTags = ImmutableList.builder();
        meterTags.add((Object)Tag.of((String)"env", (String)space));
        meterTags.add((Object)Tag.of((String)"release", (String)this.release));
        meterTags.add((Object)Tag.of((String)"service", (String)service));
        this.meterRegistry.config().commonTags((Iterable)meterTags.build());
        this.meterRegistry.add((MeterRegistry)new DropwizardMeterRegistry(new DropwizardConfig(){
            final /* synthetic */ ApplicationProperties val$props;
            {
                this.val$props = applicationProperties;
            }

            public String prefix() {
                return "boot";
            }

            public String get(String key) {
                return this.val$props.cfg().getString(key, null);
            }
        }, this.metricRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return Double.NaN;
            }
        });
        this.binders.add((MeterBinder)new FileDescriptorMetrics());
        this.binders.add((MeterBinder)new ClassLoaderMetrics());
        this.binders.add((MeterBinder)new JvmGcMetrics());
        this.binders.add((MeterBinder)new ProcessorMetrics());
        this.binders.add((MeterBinder)new JvmThreadMetrics());
        this.binders.add((MeterBinder)new JvmHeapPressureMetrics());
        this.binders.add((MeterBinder)new JvmCompilationMetrics());
        this.binders.add((MeterBinder)new JvmInfoMetrics());
        this.binders.add((MeterBinder)new JvmMemoryMetrics());
        this.binders.add((MeterBinder)new LogbackMetrics());
        if (!((Boolean)((ApplicationProperties)props).APP_METRICS_DRY_RUN.get()).booleanValue()) {
            PlainServiceInfo si;
            Optional optelk = UPSs.findServiceInfoByName(this, "elastic-search");
            Optional optinf = UPSs.findServiceInfoByName(this, "influx");
            if (optelk.isPresent()) {
                si = (PlainServiceInfo)((Object)optelk.get());
                if (((Boolean)((ApplicationProperties)props).APP_METRICS_ELK_REPORTER_ENABLED.get()).booleanValue()) {
                    this.meterRegistry.add((MeterRegistry)new ElasticMeterRegistry(new ElasticConfig(){
                        final /* synthetic */ ApplicationProperties val$props;
                        final /* synthetic */ PlainServiceInfo val$si;
                        {
                            this.val$props = applicationProperties;
                            this.val$si = plainServiceInfo;
                        }

                        public int batchSize() {
                            return (Integer)this.val$props.APP_METRICS_BULK_SIZE.get();
                        }

                        public String host() {
                            return String.format("%s://%s:%d", this.val$si.getScheme(), this.val$si.getHost(), this.val$si.getPort());
                        }

                        public String userName() {
                            return this.val$si.getUserName();
                        }

                        public String password() {
                            return this.val$si.getPassword();
                        }

                        public Duration connectTimeout() {
                            return Duration.ofSeconds(((Integer)this.val$props.TCP_CONNECTION_TIMEOUT.get()).intValue());
                        }

                        public Duration readTimeout() {
                            return Duration.ofSeconds(((Integer)this.val$props.TCP_SOCKET_TIMEOUT.get()).intValue());
                        }

                        public String get(String k) {
                            return this.val$props.cfg().getString(k, null);
                        }
                    }, Clock.SYSTEM));
                }
            }
            if (optinf.isPresent()) {
                si = (PlainServiceInfo)((Object)optinf.get());
                if (((Boolean)((ApplicationProperties)props).APP_METRICS_INFLUX_REPORTER_ENABLED.get()).booleanValue()) {
                    this.meterRegistry.add((MeterRegistry)new InfluxMeterRegistry(new InfluxConfig(){
                        final /* synthetic */ ApplicationProperties val$props;
                        final /* synthetic */ PlainServiceInfo val$si;
                        {
                            this.val$props = applicationProperties;
                            this.val$si = plainServiceInfo;
                        }

                        public int batchSize() {
                            return (Integer)this.val$props.APP_METRICS_BULK_SIZE.get();
                        }

                        public String uri() {
                            return String.format("%s://%s:%d", this.val$si.getScheme(), this.val$si.getHost(), this.val$si.getPort());
                        }

                        public String userName() {
                            return this.val$si.getUserName();
                        }

                        public String password() {
                            return this.val$si.getPassword();
                        }

                        public String db() {
                            return this.val$si.getPath();
                        }

                        public Duration connectTimeout() {
                            return Duration.ofSeconds(((Integer)this.val$props.TCP_CONNECTION_TIMEOUT.get()).intValue());
                        }

                        public Duration readTimeout() {
                            return Duration.ofSeconds(((Integer)this.val$props.TCP_SOCKET_TIMEOUT.get()).intValue());
                        }

                        public String get(String k) {
                            return this.val$props.cfg().getString(k, null);
                        }
                    }, Clock.SYSTEM));
                }
            }
        }
        for (MeterBinder binder : this.binders) {
            binder.bindTo(this.meterRegistry());
        }
        this.platform = new FixedSizePlatform((ApplicationProperties)props, (MeterRegistry)this.meterRegistry);
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain((String)((ApplicationProperties)props).APP_JMX_DOMAIN.get()).build();
        this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).scheduleOn((ScheduledExecutorService)this.platform).build();
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractBootstrap.this.logger.info("running shutdown hook now ...");
                try {
                    AbstractBootstrap.this.shutdown();
                }
                catch (Throwable err) {
                    AbstractBootstrap.this.logger.error(err.getMessage(), err);
                }
            }
        });
        this.healthCheckRegistry = new HealthCheckRegistry();
        this.healthCheckRegistry.addListener(new HealthCheckRegistryListener(){

            public void onHealthCheckAdded(String name, HealthCheck healthCheck) {
                if (healthCheck instanceof BootstrapAware) {
                    try {
                        ((BootstrapAware)healthCheck).setBootstrap(AbstractBootstrap.this);
                    }
                    catch (Exception err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                    }
                }
            }

            public void onHealthCheckRemoved(String name, HealthCheck healthCheck) {
                if (healthCheck instanceof AbstractHealtchCheck) {
                    AbstractHealtchCheck preDestoy = (AbstractHealtchCheck)healthCheck;
                    try {
                        preDestoy.destroy();
                    }
                    catch (Exception err) {
                        AbstractBootstrap.this.logger.error(err.getMessage(), (Throwable)err);
                    }
                }
            }
        });
    }

    @Override
    public ConfigurableApplicationContext run(String ... args) {
        boolean isHealthy = true;
        HashSet<String> unhealthy = new HashSet<String>();
        Lock rwLock = this.lock.writeLock();
        rwLock.lock();
        try {
            if (((Boolean)((ApplicationProperties)this.props).APP_WAIT_FOR_HEALTHCHECKS_ENABLED.get()).booleanValue()) {
                this.logger.debug("about to run health-checks now ...");
                int it = 0;
                long now = System.currentTimeMillis();
                long timeout = TimeUnit.SECONDS.toMillis(((Integer)((ApplicationProperties)this.props).APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT.get()).intValue());
                isHealthy = false;
                while (System.currentTimeMillis() - now <= timeout) {
                    boolean tmp = true;
                    ++it;
                    unhealthy.clear();
                    for (Map.Entry entry : this.healthCheckRegistry().runHealthChecks(new HealthCheckFilter(){

                        public boolean matches(String name, HealthCheck healthCheck) {
                            if (healthCheck instanceof AbstractHealtchCheck) {
                                AbstractHealtchCheck check = (AbstractHealtchCheck)healthCheck;
                                return check.isBootstrapOnly();
                            }
                            return true;
                        }
                    }).entrySet()) {
                        this.logger.debug("iteration({}) ::: healthcheck({}) - isHealthy({})", new Object[]{it, entry.getKey(), ((HealthCheck.Result)entry.getValue()).isHealthy()});
                        tmp &= ((HealthCheck.Result)entry.getValue()).isHealthy();
                        if (((HealthCheck.Result)entry.getValue()).isHealthy()) continue;
                        unhealthy.add((String)entry.getKey());
                    }
                    if (tmp) {
                        isHealthy = true;
                        break;
                    }
                    int waitSec = (Integer)((ApplicationProperties)this.props).APP_WAIT_FOR_HEALTHCHECKS_INTERVAL.get();
                    this.logger.debug("about to wait {} sec before next health_check attempt ...", (Object)waitSec);
                    Uninterruptibles.sleepUninterruptibly((long)waitSec, (TimeUnit)TimeUnit.SECONDS);
                }
            }
            if (isHealthy) {
                long now = System.currentTimeMillis();
                this.logger.debug("about to perform actual application start ...");
                this.doStart(args);
                this.logger.info("application started in={} sec ...", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - now));
                if (((Boolean)((ApplicationProperties)this.props).APP_SHUTDOWN_HOOK_ENABLED.get()).booleanValue()) {
                    this.logger.info("shutdown hook has been registered ...");
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                }
                ConfigurableApplicationContext configurableApplicationContext = this.applicationContext;
                return configurableApplicationContext;
            }
            try {
                this.logger.info("app will not start due to failed health checks ...");
                this.removeAllHealthChecks();
                if (this.platform != null) {
                    this.platform.dispose();
                }
                throw new Throwable("unhealthy = " + ((Object)unhealthy).toString());
            }
            catch (Throwable err) {
                boolean removed;
                if (isHealthy) {
                    this.logger.error(err.getMessage(), err);
                }
                if (removed = Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
                    this.logger.info("removed shutdown hook ...");
                }
                if (isHealthy) {
                    this.logger.error("application failed to start, stopping lifecycle thread ...");
                    try {
                        this.shutdown();
                    }
                    catch (Throwable t) {
                        this.logger.warn(t.getMessage(), t);
                    }
                }
                this.logger.info("dumping all threads now before termination ... ");
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                ThreadDump dump = new ThreadDump(threadMXBean);
                dump.dump((OutputStream)System.err);
                if (!this.isDevMode()) {
                    try (Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry).scheduleOn((ScheduledExecutorService)this.platform).build();){
                        reporter.report();
                    }
                }
                Throwables.throwIfUnchecked((Throwable)err);
                throw new RuntimeException(err);
            }
        }
        finally {
            rwLock.unlock();
        }
    }

    protected void postProcessApplicationContext(ConfigurableApplicationContext context) {
        super.postProcessApplicationContext(context);
        for (Channel channel : this.channels) {
            if (channel instanceof SmartApplicationListener) {
                context.addApplicationListener((ApplicationListener)((SmartApplicationListener)channel));
            }
            if (!(channel instanceof BeanFactoryPostProcessor)) continue;
            context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)channel);
        }
    }

    @Override
    public void shutdown() throws Exception {
        Lock rwLock = this.lock.writeLock();
        rwLock.lock();
        try {
            this.doStop();
        }
        finally {
            rwLock.unlock();
        }
    }

    @Override
    public void exit(int code) {
        Lock rwLock = this.lock.writeLock();
        rwLock.lock();
        try {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            System.exit(code);
        }
        finally {
            rwLock.unlock();
        }
    }

    public PROPS props() {
        return this.props;
    }

    @Override
    public ApplicationConfig cfg() {
        return ((ApplicationProperties)this.props).cfg();
    }

    @Override
    public FixedSizePlatform platform() {
        return this.platform;
    }

    @Override
    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public HealthCheckRegistry healthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    @Override
    public Cloud cloud() {
        return this.cloud;
    }

    @Override
    public ConfigurableApplicationContext context() {
        return this.applicationContext;
    }

    @Override
    public KeyStore keyStore() {
        return this.keyStore;
    }

    @Override
    public String release() {
        return this.release;
    }

    @Override
    public boolean isDevMode() {
        return (Boolean)((ApplicationProperties)this.props).APP_DEV_MODE.get();
    }

    @Override
    public int port() {
        return (Integer)((ApplicationProperties)this.props).CLOUD_APP_PORT.get();
    }

    @Override
    public int secondaryPort() {
        return (Integer)((ApplicationProperties)this.props).CLOUD_APP_SECONDARY_PORT.get();
    }

    @Override
    public int tertiaryPort() {
        return (Integer)((ApplicationProperties)this.props).CLOUD_APP_TERTIARY_PORT.get();
    }

    @Override
    public String spaceName() {
        return (String)((ApplicationProperties)this.props).CLOUD_APP_SPACE_NAME.get();
    }

    @Override
    public String appId() {
        return (String)((ApplicationProperties)this.props).CLOUD_APP_ID.get();
    }

    public void addBootstrapRegistryInitializer(BootstrapRegistryInitializer initializer) {
        if (initializer instanceof BootstrapAware) {
            ((BootstrapAware)initializer).setBootstrap(this);
        }
        super.addBootstrapRegistryInitializer(initializer);
    }

    @Override
    public boolean addChannel(Channel acceptor) {
        if (acceptor instanceof BootstrapAware) {
            ((BootstrapAware)((Object)acceptor)).setBootstrap(this);
        }
        return this.channels.add(acceptor);
    }

    @Override
    public boolean isHealthy() {
        SortedMap results = this.healthCheckRegistry.runHealthChecks();
        return results.isEmpty();
    }

    @Override
    public void registerHealthCheck(String name, HealthCheck check) {
        this.healthCheckRegistry().register(name, check);
    }

    @Override
    public SentryClient sentry() {
        return this.sentry;
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    public boolean shouldSend(Event event) {
        return (Boolean)((ApplicationProperties)this.props).APP_SENTRY_ENABLED.get();
    }

    public Object getBean(String name) throws BeansException {
        return this.context().getBean(name);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.context().getBean(name, requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.context().getBean(name, args);
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return (T)this.context().getBean(requiredType);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        return (T)this.context().getBean(requiredType, args);
    }

    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) {
        return this.context().getBeanProvider(requiredType);
    }

    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        return this.context().getBeanProvider(requiredType);
    }

    public boolean containsBean(String name) {
        return this.context().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.context().isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.context().isPrototype(name);
    }

    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        return this.context().isTypeMatch(name, typeToMatch);
    }

    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        return this.context().isTypeMatch(name, typeToMatch);
    }

    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.context().getType(name);
    }

    public Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        return this.context().getType(name, allowFactoryBeanInit);
    }

    public String[] getAliases(String name) {
        return this.context().getAliases(name);
    }

    protected void doStart(String ... args) throws Throwable {
        this.addBootstrapRegistryInitializer(new BootstrapRegistryInitializer(){

            public void initialize(BootstrapRegistry registry) {
                registry.addCloseListener((ApplicationListener)new ApplicationListener<BootstrapContextClosedEvent>(){

                    public void onApplicationEvent(BootstrapContextClosedEvent event) {
                        ConfigurableListableBeanFactory beanFactory = event.getApplicationContext().getBeanFactory();
                        beanFactory.registerSingleton("cloud", (Object)AbstractBootstrap.this.cloud());
                        beanFactory.registerSingleton("tracer", (Object)AbstractBootstrap.this.tracer());
                        beanFactory.registerSingleton("platform", (Object)AbstractBootstrap.this.platform());
                        beanFactory.registerSingleton("metric-registry", (Object)AbstractBootstrap.this.metricRegistry());
                        beanFactory.registerSingleton("health-check-registry", (Object)AbstractBootstrap.this.healthCheckRegistry());
                    }
                });
            }
        });
        this.addInitializers(new ApplicationContextInitializer[]{new ApplicationContextInitializer<ConfigurableApplicationContext>(){

            public void initialize(ConfigurableApplicationContext ctx) {
                ConfigurableListableBeanFactory factory = ctx.getBeanFactory();
                factory.addBeanPostProcessor((BeanPostProcessor)new DestructionAwareBeanPostProcessor(){

                    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                        if (bean instanceof BootstrapAware) {
                            try {
                                ((BootstrapAware)bean).setBootstrap(AbstractBootstrap.this);
                            }
                            catch (Exception err) {
                                throw new BeanCreationException(err.getMessage(), (Throwable)err);
                            }
                        }
                        return bean;
                    }

                    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                        return bean;
                    }

                    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
                    }
                });
            }
        }});
        this.applicationContext = super.run(args);
        this.jmxReporter.start();
        if (!this.isDevMode()) {
            this.consoleReporter.start((long)((Integer)((ApplicationProperties)this.props).APP_TIMER_INTERVAL.get()).intValue(), TimeUnit.SECONDS);
        }
        for (Channel acceptor : this.channels) {
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)acceptor);
        }
        DefaultApplicationArguments arguments = new DefaultApplicationArguments(args);
        for (Channel acceptor : this.channels) {
            acceptor.run((ApplicationArguments)arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        this.removeAllHealthChecks();
        for (Channel acceptor : this.channels) {
            try {
                this.logger.info("disposing acceptor {} ...", (Object)acceptor);
                acceptor.destroy();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
        try {
            if (this.applicationContext != null) {
                this.logger.info("closing application now ...");
                this.applicationContext.close();
            }
        }
        finally {
            this.logger.info("stoppping JMX reporter ...");
            this.jmxReporter.close();
            this.consoleReporter.close();
            this.logger.info("shutting down platform now ...");
            this.platform.dispose();
            if (this.sentry != null) {
                this.logger.info("closing sentry now ...");
                this.sentry.closeConnection();
            }
            Iterator<MeterBinder> it = this.binders.iterator();
            while (it.hasNext()) {
                MeterBinder binder = it.next();
                try {
                    if (!(binder instanceof AutoCloseable)) continue;
                    ((AutoCloseable)binder).close();
                }
                catch (Throwable t) {
                    this.logger.warn(t.getMessage(), t);
                }
                finally {
                    it.remove();
                }
            }
            if (((Boolean)((ApplicationProperties)this.props).APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED.get()).booleanValue()) {
                this.logger.debug("disposing CFG ...");
                ApplicationConfig cfg = ((ApplicationProperties)this.props).cfg();
                for (String next : cfg.getConfigNames()) {
                    Config removed = cfg.removeConfig(next);
                    if (!(removed instanceof PollingDynamicConfig)) continue;
                    PollingDynamicConfig pdc = (PollingDynamicConfig)removed;
                    pdc.shutdown();
                }
                cfg.shutdown();
            }
        }
    }

    private void configureLogging(MutableObject<URL> logFile) throws Exception {
        InputStream io;
        ApplicationInstanceInfo info = this.cloud.getApplicationInstanceInfo();
        Map cloudProps = info.getProperties();
        Obfuscators.init(this.props());
        String space = cloudProps.get("cloud.application.space_name").toString();
        String host = cloudProps.get("cloud.application.host").toString();
        String slot = cloudProps.get("cloud.application.instance_index").toString();
        String service = info.getAppId();
        LoggerContext loggerFactory = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerFactory.setPackagingDataEnabled(this.isDevMode());
        boolean toConfigure = true;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("space", space);
        options.put("host", host);
        options.put("service", service);
        options.put("slot", slot);
        options.put("release", this.release());
        HashMap copyOfCfg = Maps.newHashMap();
        Iterator keys = this.cfg().getKeys();
        while (keys.hasNext()) {
            String next = (String)keys.next();
            Object raw = this.cfg().getRawProperty(next);
            copyOfCfg.put(next, raw);
        }
        final AtomicBoolean logging = new AtomicBoolean((Boolean)((ApplicationProperties)this.props()).APP_LOGGING_DRY_RUN.get());
        final AtomicBoolean alerts = new AtomicBoolean((Boolean)((ApplicationProperties)this.props()).APP_ALERTS_DRY_RUN.get());
        Config git = this.cfg().getConfig("core.GIT_CFG");
        git.addListener((ConfigListener)new DefaultConfigListener(){

            public void onConfigUpdated(Config config) {
                if (config.containsKey("app.logging.dry-run")) {
                    boolean updated = config.getBoolean("app.logging.dry-run");
                    logging.set(updated);
                } else if (config.containsKey("app.alerts.dry-run")) {
                    boolean updated = config.getBoolean("app.alerts.dry-run");
                    alerts.set(updated);
                }
            }
        });
        Supplier<Boolean> loggingDryRun = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return logging.get();
            }
        };
        Supplier<Boolean> alertsDryRun = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return alerts.get();
            }
        };
        if (((Boolean)((ApplicationProperties)this.props()).APP_DEV_MODE.get()).booleanValue()) {
            try {
                URL logbackTest = ResourceUtils.getURL((String)"classpath:logback-test.xml");
                io = logbackTest.openStream();
                try {
                    toConfigure = false;
                    loggerFactory.putObject(LoggingSystem.class.getName(), new Object());
                }
                finally {
                    if (io != null) {
                        io.close();
                    }
                }
            }
            catch (FileNotFoundException logbackTest) {
                // empty catch block
            }
        }
        if (toConfigure) {
            AlertLoggingFilter alertFilter = new AlertLoggingFilter(((ApplicationProperties)this.props).SENTRY_ALERTS_FILTER_ENABLED, ((ApplicationProperties)this.props).SENTRY_ALERTS_EX_CLASSES_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_EX_MSG_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_EX_PATTERNS_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_LOG_MESSAGES_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_LOGGERS_TO_IGNORE);
            if (logFile.getValue() != null) {
                io = ((URL)logFile.getValue()).openStream();
                try {
                    Logback.configureFrom((LoggerContext)loggerFactory, (AlertLoggingFilter)alertFilter, (InputStream)io, options, (SentryClient)this.sentry(), (Map)copyOfCfg, (Supplier)loggingDryRun, (Supplier)alertsDryRun);
                    loggerFactory.putObject(LoggingSystem.class.getName(), new Object());
                }
                finally {
                    if (io != null) {
                        io.close();
                    }
                }
            }
            try {
                URL loggingXml = ResourceUtils.getURL((String)"classpath:logging.xml");
                try (InputStream io2 = loggingXml.openStream();){
                    Logback.configureFrom((LoggerContext)loggerFactory, (AlertLoggingFilter)alertFilter, (InputStream)io2, options, (SentryClient)this.sentry(), (Map)copyOfCfg, (Supplier)loggingDryRun, (Supplier)alertsDryRun);
                    loggerFactory.putObject(LoggingSystem.class.getName(), new Object());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private void removeAllHealthChecks() {
        for (String name : this.healthCheckRegistry.getNames()) {
            this.logger.info("removing health-check {} ...", (Object)name);
            this.healthCheckRegistry.unregister(name);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

