package com.turbospaces.ups;

import org.springframework.cloud.service.ServiceInfo.ServiceLabel;
import org.springframework.cloud.service.common.RelationalServiceInfo;

@ServiceLabel("hsqldb")
public class HsqlServiceInfo extends RelationalServiceInfo {
    public static final String HSQL_SCHEME = "hsqldb";

    public HsqlServiceInfo(String id, String uri) {
        super( id, uri, null, HSQL_SCHEME );
    }
    @Override
    protected String buildJdbcUrl() {
        return String.format( "jdbc:%s", getUriInfo().toString().replace( "//", "" ) );
    }
}
