package com.turbospaces.common.logging;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.cfg.ApplicationProperties;

public class Obfuscators extends AbstractBootstrapAware {
    public static Obfuscator<String> MOCK = in -> in;
    public static Obfuscator<String> JSON = MOCK;
    public static Obfuscator<String> QUERY = MOCK;

    public static String jsonStrFieldMaskPattern(String fieldName) {
        return "\"" + fieldName + "\"\\s*:\\s*\"(.*?)\"";
    }

    public static String queryParamMaskPattern(String fieldName) {
        return fieldName + "=(.*?)&" + "|" + fieldName + "=(.*?)$";
    }

    public static <PROPS extends ApplicationProperties> void init(PROPS props) {
        JSON = new MaskObfuscator(props.APP_LOGGING_JSON_MASK_PATTERNS.get());
        QUERY = new MaskObfuscator(props.APP_LOGGING_QUERY_MASK_PATTERNS.get());
    }
}
