package com.turbospaces.common.logging;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class MaskObfuscator implements Obfuscator<String> {
    private final Pattern pattern;

    public MaskObfuscator(List<String> patterns) {
        this.pattern = Pattern.compile(String.join("|", patterns), Pattern.MULTILINE);
    }

    @Override
    public String obfuscate(String message) {
        if (message == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder(message);
            Matcher matcher = pattern.matcher(sb);
            while (matcher.find()) {
                IntStream.rangeClosed(1, matcher.groupCount()).forEach(group -> {
                    if (matcher.group(group) != null) {
                        IntStream.range(matcher.start(group), matcher.end(group)).forEach(i -> sb.setCharAt(i, '*'));
                    }
                });
            }
            return sb.toString();
        } catch (Exception e) {
            return message;
        }
    }
}
