package com.turbospaces.common;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@SuppressWarnings("serial")
public class RequestReplyTimeout extends TimeoutException {
    private final int timeout;
    private final TimeUnit unit;
    private final Object key;

    public RequestReplyTimeout(int timeout, TimeUnit unit, Object key) {
        super( String.format( "no response in %s%s for %s", timeout, unit.toString().toLowerCase(), key ) );

        this.timeout = timeout;
        this.unit = Objects.requireNonNull( unit );
        this.key = Objects.requireNonNull( key );
    }
    public int getTimeout() {
        return timeout;
    }
    public TimeUnit getUnit() {
        return unit;
    }
    public Object getKey() {
        return key;
    }
}
