/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.turbospaces.boot.AbstractBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.CloudMapConfig;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.logging.Logback;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.UPSs;
import io.sentry.SentryClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.ConfigurableCloudConnector;
import org.springframework.cloud.app.ApplicationInstanceInfo;

public class ConfigurableCloudFactory
extends CloudFactory {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AbstractBootstrap bootstrap;
    private final Cloud cloud;
    private Optional<String> loggingXmlAsString = Optional.empty();

    public ConfigurableCloudFactory(ConfigurableCloudConnector connector, AbstractBootstrap bootstrap) throws Exception {
        this.registerCloudConnector(connector);
        this.bootstrap = Objects.requireNonNull(bootstrap);
        this.cloud = super.getCloud();
        ApplicationConfig cfg = bootstrap.props().cfg();
        Optional opt = UPSs.findServiceInfoByName(this.cloud, "cfg");
        if (opt.isPresent()) {
            if (((Boolean)bootstrap.props().APP_CFG_DYNAMIC_POLLING_ENABLED.get()).booleanValue()) {
                cfg.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConfigurableCloudFactory.this.apply();
                        }
                        catch (Exception ex) {
                            ConfigurableCloudFactory.this.logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                });
            } else {
                this.apply();
            }
        } else {
            this.logger.debug("'{}' is not bound to app ...", (Object)"cfg");
        }
        CloudMapConfig cfc = new CloudMapConfig(connector.getApplicationInstanceInfo());
        DefaultSettableConfig config = (DefaultSettableConfig)cfg.getConfig("core.CLOUD_CFG");
        config.setProperties((Config)cfc);
        this.configureLogging();
    }

    public Cloud getCloud() {
        return this.cloud;
    }

    private void configureLogging() throws Exception {
        InputStream io;
        Optional<URL> logbackTest;
        ApplicationInstanceInfo info = this.cloud.getApplicationInstanceInfo();
        Map cloudProps = info.getProperties();
        String space = cloudProps.get("cloud.application.space_name").toString();
        String host = cloudProps.get("cloud.application.host").toString();
        String slot = cloudProps.get("cloud.application.instance_index").toString();
        String service = info.getAppId();
        String release = PlatformUtil.version(this.bootstrap.props().CLOUD_APP_NAME);
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        boolean toConfigure = true;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("space", space);
        map.put("host", host);
        map.put("service", service);
        map.put("slot", slot);
        map.put("release", release);
        map.put("logging-dryRun", Boolean.toString((Boolean)this.bootstrap.props().APP_LOGGING_DRY_RUN.get()));
        map.put("alerts-dryRun", Boolean.toString((Boolean)this.bootstrap.props().APP_ALERTS_DRY_RUN.get()));
        if (((Boolean)this.bootstrap.props().APP_DEV_MODE.get()).booleanValue() && (logbackTest = PlatformUtil.getResource("logback-test.xml")).isPresent()) {
            io = logbackTest.get().openStream();
            try {
                toConfigure = false;
            }
            finally {
                if (io != null) {
                    io.close();
                }
            }
        }
        if (toConfigure) {
            if (this.loggingXmlAsString.isPresent()) {
                String xmlAsString = this.loggingXmlAsString.get();
                byte[] xmlAsBytes = xmlAsString.getBytes(StandardCharsets.UTF_8);
                try (ByteArrayInputStream io2 = new ByteArrayInputStream(xmlAsBytes);){
                    Logback.configureFrom((ILoggerFactory)iLoggerFactory, (InputStream)io2, map, (SentryClient)this.bootstrap.sentry());
                }
            }
            Optional<URL> loggingXml = PlatformUtil.getResource("logging.xml");
            if (loggingXml.isPresent()) {
                io = loggingXml.get().openStream();
                try {
                    Logback.configureFrom((ILoggerFactory)iLoggerFactory, (InputStream)io, map, (SentryClient)this.bootstrap.sentry());
                }
                finally {
                    if (io != null) {
                        io.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply() throws Exception {
        final ApplicationConfig cfg = this.bootstrap.props().cfg();
        Optional opt = UPSs.findServiceInfoByName(this.cloud, "cfg");
        if (opt.isPresent()) {
            PlainServiceInfo info = (PlainServiceInfo)((Object)opt.get());
            final DefaultSettableConfig gitCfg = (DefaultSettableConfig)cfg.getConfig("core.GIT_CFG");
            File toFile = Files.createTempDirectory("cfg", new FileAttribute[0]).toFile();
            InitCommand initCmd = new InitCommand().setBare(false).setDirectory(toFile);
            this.logger.debug("cloning git repo from={}", (Object)info);
            try (Git git = initCmd.call();){
                this.applyConfig(git, info);
                PullCommand pullCommand = git.pull().setRemote("origin").setTagOpt(TagOpt.FETCH_TAGS);
                pullCommand.setRemoteBranchName("master");
                if (StringUtils.isNotEmpty((CharSequence)info.getUserName()) && StringUtils.isNotEmpty((CharSequence)info.getPassword())) {
                    pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(info.getUserName(), info.getPassword()));
                }
                pullCommand.call();
                Map cloudProps = this.cloud.getApplicationInstanceInfo().getProperties();
                String spaceName = cloudProps.get("cloud.application.space_name").toString();
                String appId = this.cloud.getApplicationInstanceInfo().getAppId();
                String filename = "application.properties";
                final Properties gitProps = new Properties();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        final HashSet toRemove = new HashSet();
                        gitCfg.forEachProperty((BiConsumer)new BiConsumer<String, Object>(){

                            @Override
                            public void accept(String k, Object v) {
                                if (!gitProps.containsKey(k)) {
                                    toRemove.add(k);
                                }
                            }
                        });
                        if (!toRemove.isEmpty()) {
                            ConfigurableCloudFactory.this.logger.debug("found orphaned properties: {}", toRemove);
                            for (String prop : toRemove) {
                                gitCfg.clearProperty(prop);
                            }
                        }
                        ConfigurableCloudFactory.this.logger.debug("setting git cfg props={}", (Object)gitProps);
                        cfg.setGitProperties(gitProps);
                    }
                };
                this.logger.debug("looking for '{}' in {}:{}", new Object[]{filename, spaceName, appId});
                File dspace = new File(toFile, spaceName);
                if (dspace.exists() && dspace.isDirectory()) {
                    File dapp;
                    File fspace = new File(dspace, filename);
                    if (fspace.exists() && fspace.isFile()) {
                        try (FileInputStream io = new FileInputStream(fspace);){
                            gitProps.load(io);
                        }
                    }
                    if ((dapp = new File(dspace, appId)).exists() && dspace.isDirectory()) {
                        File fapp = new File(dapp, filename);
                        if (fapp.exists() && fapp.isFile()) {
                            try (FileInputStream io = new FileInputStream(fapp);){
                                gitProps.load(io);
                            }
                        }
                        if ((fapp = new File(dapp, filename = "logging.xml")).exists() && fapp.isFile()) {
                            String xml = new String(Files.readAllBytes(fapp.toPath()), StandardCharsets.UTF_8);
                            this.loggingXmlAsString = Optional.of(xml);
                        }
                    }
                }
                task.run();
            }
            finally {
                if (toFile.exists()) {
                    toFile.delete();
                }
            }
        }
    }

    private void applyConfig(Git git, PlainServiceInfo info) throws URISyntaxException, IOException {
        this.logger.debug("patching git config ...");
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("http", null, "sslVerify", false);
        config.setBoolean("gc", null, "autoDetach", false);
        URIish urish = new URIish(StringUtils.removeEnd((String)info.getUri(), (String)"/"));
        RemoteConfig remoteConfig = new RemoteConfig((org.eclipse.jgit.lib.Config)config, "origin");
        remoteConfig.addURI(urish);
        RefSpec refSpec = new RefSpec();
        refSpec = refSpec.setForceUpdate(true);
        refSpec = refSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + remoteConfig.getName() + "/*");
        remoteConfig.addFetchRefSpec(refSpec);
        remoteConfig.update((org.eclipse.jgit.lib.Config)config);
        config.save();
    }
}

