/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.di;

import com.google.inject.Binder;
import com.google.inject.ProvisionException;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.boot.BootstrapPlugin;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.di.PreDestroyable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Provider;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBootstrapPlugin<T>
implements BootstrapAware,
BootstrapPlugin,
ConcurrentInitializer<T>,
Provider<T>,
PreDestroyable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Bootstrap bootstrap;
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final ConcurrentInitializer<T> init;
    private final Class<T> type;

    protected AbstractBootstrapPlugin(Class<T> type) {
        this.type = Objects.requireNonNull(type);
        this.init = new LazyInitializer<T>(){

            protected T initialize() throws ConcurrentException {
                try {
                    return AbstractBootstrapPlugin.this.createOnce();
                }
                catch (RuntimeException err) {
                    throw err;
                }
                catch (Exception err) {
                    throw new ConcurrentException((Throwable)err);
                }
            }
        };
    }

    @Override
    public void setBootstrap(Bootstrap bootstrap) throws Exception {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }

    @Override
    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void preDestroy() throws Exception {
        Object obj;
        if (this.destroyed.compareAndSet(false, true) && (obj = this.init.get()) != null) {
            this.destroyOnce(obj);
        }
    }

    public final T get() {
        try {
            return (T)this.init.get();
        }
        catch (Exception err) {
            throw new ProvisionException("failed to configure plugin", (Throwable)err);
        }
    }

    @Override
    public final void configure(Binder binder) {
        binder.requestInjection((Object)this);
        binder.bind(this.type).toProvider((Provider)this).asEagerSingleton();
    }

    protected ApplicationProperties props() {
        return this.bootstrap.props();
    }

    protected abstract T createOnce() throws Exception;

    protected abstract void destroyOnce(T var1) throws Exception;
}

