/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.boot.Platform;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.ThrowableAction;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class FixedSizePlatform
implements Platform {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Scheduler scheduler;
    private final ScheduledThreadPoolExecutor executor;
    private final ApplicationProperties props;

    public FixedSizePlatform(ApplicationProperties props, MeterRegistry meter) {
        this.props = Objects.requireNonNull(props);
        int psize = (Integer)props.APP_PLATFORM_POOL_SIZE.get();
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(false);
        tfb.setNameFormat("platform-worker-%d");
        this.executor = new ScheduledThreadPoolExecutor(psize, tfb.build(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.executor.prestartAllCoreThreads();
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)this.executor, (String)"reactor");
        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics((ExecutorService)this.executor, "platform", Collections.emptyList());
        metrics.bindTo(meter);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executor.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public void execute(final Runnable command) {
        final Map mdc = MDC.getCopyOfContextMap();
        if (mdc == null) {
            this.executor.execute(command);
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    MDC.setContextMap((Map)mdc);
                    try {
                        command.run();
                    }
                    catch (Throwable err) {
                        FixedSizePlatform.this.logger.error(err.getMessage(), err);
                    }
                    finally {
                        MDC.clear();
                    }
                }
            });
        }
    }

    @Override
    public void work(final ThrowableAction action) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    action.apply();
                }
                catch (Exception err) {
                    FixedSizePlatform.this.logger.error(err.getMessage(), (Throwable)err);
                }
            }
        });
    }

    @Override
    @PreDestroy
    public void preDestroy() {
        int timeout = (Integer)this.props.APP_PLATFORM_GRACEFUL_TIMEOUT.get();
        PlatformUtil.shutdownExecutor(this.executor, timeout);
        this.logger.debug("stopped platform-worker pool ...");
    }
}

