/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closeables;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.boot.BootstrapPlugin;
import com.turbospaces.boot.Channel;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.ThrowableAction;
import com.turbospaces.di.AbstractBootstrapAwareModule;
import com.turbospaces.di.DiEngine;
import com.turbospaces.di.GuiceDiEngine;
import com.turbospaces.di.PreDestroyable;
import com.turbospaces.healthchecks.HttpHealthCheck;
import com.turbospaces.healthchecks.SocketHealthCheck;
import com.turbospaces.ups.PlainServiceInfo;
import io.jaegertracing.client.Version;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.service.UriBasedServiceInfo;

public class BootstrapTest {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        int port = PlatformUtil.freePort();
        MockCloud cfg = MockCloud.newMock();
        cfg.appPort(port);
        cfg.withKafka(9092);
        cfg.withZookeeper(2181);
        URIBuilder uri = new URIBuilder().setScheme("http").setHost("localhost").setPath("/v1/status").setPort(port);
        ApplicationProperties props = new ApplicationProperties(cfg.build());
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.addPlugin((BootstrapPlugin)new HttpClientPlugin());
        bootstrap.addChannel((Channel)new InboundChannel(uri.build()));
        bootstrap.start((DiEngine)GuiceDiEngine.create((Module[])new Module[]{new DiModule()}));
        try {
            Injector injector = (Injector)bootstrap.diEngine().injector();
            for (Map.Entry entry : injector.getAllBindings().entrySet()) {
                this.logger.debug(((Binding)entry.getValue()).toString());
            }
            injector.getInstance(CloseableHttpClient.class);
            Bean bean = (Bean)injector.getInstance(Bean.class);
            this.logger.debug(bean.toString());
            HttpHealthCheck check1 = new HttpHealthCheck(props, uri.build());
            Assertions.assertTrue((boolean)check1.execute().isHealthy());
            SocketHealthCheck check2 = new SocketHealthCheck(props, (UriBasedServiceInfo)new PlainServiceInfo("my-service-" + Version.get(), uri.toString()));
            Assertions.assertTrue((boolean)check2.execute().isHealthy());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    public static class HttpClientPlugin
    extends AbstractBootstrapAwareModule
    implements BootstrapPlugin,
    PreDestroyable,
    Provider<CloseableHttpClient> {
        private CloseableHttpClient client;

        public CloseableHttpClient get() {
            if (this.client == null) {
                this.client = HttpClients.createMinimal();
            }
            return this.client;
        }

        @PreDestroy
        public void preDestroy() throws Exception {
            Closeables.close((Closeable)this.client, (boolean)true);
        }

        public void configure() {
            super.configure();
            this.bind(CloseableHttpClient.class).toProvider((Provider)this).asEagerSingleton();
        }
    }

    public static class InboundChannel
    implements Channel,
    BootstrapAware {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final URI uri;
        private ServerBootstrap http = ServerBootstrap.bootstrap();
        private Bootstrap bootstrap;
        private HttpServer channel;
        @Inject
        CloseableHttpClient httpClient;

        public InboundChannel(URI uri) {
            this.uri = uri;
        }

        public void setBootstrap(Bootstrap bootstrap) throws Exception {
            this.bootstrap = bootstrap;
        }

        public Bootstrap getBootstrap() {
            return this.bootstrap;
        }

        public void accept() throws Exception {
            this.http = ServerBootstrap.bootstrap();
            this.http.setListenerPort(this.bootstrap.port());
            this.http.setHandlerMapper(new HttpRequestHandlerMapper(){

                public HttpRequestHandler lookup(HttpRequest request) {
                    return new HttpRequestHandler(){

                        public void handle(HttpRequest req, HttpResponse resp, HttpContext context) throws HttpException, IOException {
                            String reqUri = req.getRequestLine().getUri();
                            if (reqUri.equals(uri.getPath())) {
                                resp.setStatusCode(200);
                                resp.setEntity((HttpEntity)new StringEntity(req.toString()));
                            } else {
                                resp.setStatusCode(404);
                            }
                        }
                    };
                }
            });
            this.channel = this.http.create();
            this.channel.start();
            HttpGet req = new HttpGet();
            req.setURI(this.uri);
            final CountDownLatch latch = new CountDownLatch(1);
            try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
                final String text = EntityUtils.toString((HttpEntity)resp.getEntity());
                this.bootstrap.platform().work(new ThrowableAction(){

                    public void apply() throws Exception {
                        logger.debug(text);
                        latch.countDown();
                    }
                });
            }
            latch.await();
        }

        public void dispose() throws Exception {
            if (this.channel != null) {
                this.channel.stop();
            }
        }
    }

    public static class DiModule
    implements Module,
    BootstrapAware {
        private Bootstrap bootstrap;

        public void setBootstrap(Bootstrap bootstrap) throws Exception {
            this.bootstrap = bootstrap;
        }

        public Bootstrap getBootstrap() {
            return this.bootstrap;
        }

        public void configure(Binder binder) {
            String appId = this.bootstrap.appId();
            Names.bindProperties((Binder)binder, (Map)ImmutableMap.of((Object)"appId", (Object)appId));
            binder.bind(Bean.class).asEagerSingleton();
        }
    }

    public static class Bean
    implements BootstrapAware {
        private Bootstrap bootstrap;
        @Inject
        @Named(value="appId")
        String appId;
        @Inject
        CloseableHttpClient client;

        public void setBootstrap(Bootstrap bootstrap) throws Exception {
            this.bootstrap = bootstrap;
        }

        public Bootstrap getBootstrap() {
            return this.bootstrap;
        }

        public String toString() {
            ToStringBuilder toString = PlatformUtil.noClassNameToString((Object)this);
            return toString.append("appId", (Object)this.appId).append("client", (Object)this.client).append("version", (Object)this.bootstrap.release()).build();
        }
    }
}

