package com.turbospaces.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.netflix.archaius.api.exceptions.ConfigException;
import com.turbospaces.boot.FixedSizePlatform;
import com.turbospaces.boot.Platform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import io.micrometer.core.instrument.simple.SimpleMeterRegistry;

public class CompletableRequestReplyMapperTest {
    Logger logger = LoggerFactory.getLogger( getClass() );
    Platform platform;
    CompletableRequestReplyMapper<String, Long> mapper;

    @BeforeEach
    public void before() throws ConfigException {
        ApplicationProperties props = new ApplicationProperties( ApplicationConfig.create() );
        platform = new FixedSizePlatform( props, new SimpleMeterRegistry() );
        mapper = new CompletableRequestReplyMapper<>();
    }
    @AfterEach
    public void after() throws Exception {
        platform.preDestroy();
    }
    @Test
    public void works() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric( 4 );
        CountDownLatch l = new CountDownLatch( 1 );
        CompletableFuture<Long> f = mapper.acquire( key, 15, TimeUnit.SECONDS );
        f.whenCompleteAsync( new BiConsumer<Long, Throwable>() {
            @Override
            public void accept(Long value, Throwable t) {
                if ( value != null ) {
                    l.countDown();
                }
            }
        }, platform );
        Assertions.assertEquals( 1, mapper.pendingCount() );
        mapper.complete( key, System.currentTimeMillis() );
        l.await();
        Assertions.assertEquals( 0, mapper.pendingCount() );
    }
    @Test
    public void timeout() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric( 4 );
        CountDownLatch l = new CountDownLatch( 1 );
        CompletableFuture<Long> f = mapper.acquire( key, 1, TimeUnit.SECONDS );
        f.whenCompleteAsync( new BiConsumer<Long, Throwable>() {
            @Override
            public void accept(Long value, Throwable t) {
                if ( t != null ) {
                    logger.error( t.getMessage(), t );
                    l.countDown();
                }
            }
        }, platform );
        l.await();
        Thread.sleep( 100 ); // wait due to asynchronous cleanup
        Assertions.assertEquals( 0, mapper.pendingCount() );
    }
}
